<?php

/**
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

use Contao\DC_Table;
use Contao\DataContainer;
use Contao\Config;

$GLOBALS['TL_DCA']['tl_vr_wa_reservation'] = array
(

    // Config
    'config' => array
    (
        'dataContainer'    => DC_Table::class,
//        'doNotCopyRecords' => true,
//        'doNotDeleteRecords' => true,
        'backlink'         => 'do=weinanlieferung',
        'enableVersioning' => true,
        'sql'              => array
        (
            'keys' => array
            (
                'id' => 'primary',
                'pid' => 'index'
            )
        )
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => DataContainer::MODE_SORTED,
            'fields' => array('pid'/*,'(SELECT s.time FROM tl_vr_wa_slot s WHERE s.id = tl_vr_wa_reservation.pid) ASC'*/),
            //            'disableGrouping' => true,
            'panelLayout' => 'filter;sort,limit',
        ),
        'label' => array(
            'fields'                  => array('pid','behaelter','uid'),
            'format'                  => '%s',
            'showColumns'             => true,
        ),
        'global_operations' => array
        (
            'all' => array
            (
                'href'                => 'act=select',
                'class'               => 'header_edit_all',
                'attributes'          => 'onclick="Backend.getScrollOffset()" accesskey="e"'
            )
        ),
        'operations' => array
        (
            'edit' => array
            (
                'href'                => 'act=edit',
                'icon'                => 'edit.gif',
            ),
            'copy' => array
            (
                'href'                => 'act=paste&amp;mode=copy',
                'icon'                => 'copy.svg'
            ),
            'cut' => array
            (
                'href'                => 'act=paste&amp;mode=cut',
                'icon'                => 'cut.svg',
                'attributes'          => 'onclick="Backend.getScrollOffset()"'
            ),
            'delete' => array
            (
                'href'                => 'act=delete',
                'icon'                => 'delete.gif',
            ),
            'toggle' => array
            (
                'href'                => 'act=toggle&amp;field=buchbar',
                'icon'                => 'visible.svg',
                'showInHeader'        => true
            ),
            'show' => array
            (
                'icon'                => 'show.gif',
            ),
        )
    ),

    // Palettes
    'palettes' => array
    (
        '__selector__' => array(),
        'default' => 'pid,uid,behaelter,sorten,lage,ernteart,upload;{approval_legend},approved;{checkin_legend},checked_in,behaelter_numbers'
    ),

    // Subpalettes
    'subpalettes' => array
    (
    ),

    // Fields
    'fields' => array
    (
        'id'          => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment"
        ),
        'pid'         => array
        (
            'exclude'                 => true,
            'inputType' => 'select',
            'foreignKey' => 'tl_vr_wa_slot.time',
            'eval'       => array('mandatory'=>true,'chosen'=>true,'includeBlankOption'=>true,'submitOnChange'=>true),
            'sql'        => "int(10) unsigned NOT NULL default '0'",
            'relation'   => array('type' => 'belongsTo', 'load' => 'lazy')
        ),
        'tstamp'      => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'"
        ),
        'nc_sent'      => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'"
        ),
        'uid'         => array
        (
            'exclude'                 => true,
            'inputType' => 'select',
            'foreignKey' => 'tl_member.username',
            'eval'       => array('mandatory'=>true,'chosen'=>true,'includeBlankOption'=>true,'tl_class'=>'w50'),
            'sql'        => "int(10) unsigned NOT NULL default '0'",
            'relation'   => array('type' => 'belongsTo', 'load' => 'lazy')
        ),
        'lage'       => array
        (
            'exclude'                 => true,
            'inputType'               => 'checkbox',
            'eval'  => array('mandatory'=>true,'multiple'=>true, 'csv'=>',','tl_class'=>'w50'),
            'sql'       => "blob NULL",
            'relation'   => array('type' => 'hasMany', 'load' => 'lazy', 'table'=>'tl_vr_wa_lage')
        ),
        'behaelter'         => array
        (
            'exclude'                 => true,
            'inputType'               => 'text',
            'eval'       => array('rgxp'=>'natural','tl_class'=>'w50'),
            'sql'        => "int(4) unsigned NOT NULL default 0",
        ),
        'sorten'       => array
        (
            'exclude'                 => true,
            'inputType'               => 'checkbox',
            'eval'  => array('multiple'=>true, 'csv'=>';','tl_class'=>'w50'),
            'sql'       => "blob NULL",
        ),
        'ernteart'       => array
        (
            'exclude'                 => true,
            'inputType'               => 'checkbox',
            'eval'  => array('multiple'=>true, 'csv'=>',','tl_class'=>'w50'),
            'sql'       => "blob NULL",
        ),
        'upload' => array
        (
            'exclude'                 => true,
            'inputType'               => 'fileTree',
            'eval'                    => array('filesOnly'=>true, 'fieldType'=>'radio', 'tl_class'=>'clr w50', 'extensions'=>Config::get('allowedDownload')),
            'sql'                     => "binary(16) NULL"
        ),
        'filename' => array
        (
            'exclude'                 => true,
            'inputType'               => 'text',
            'eval'                    => array
            (
                'maxlength' => 255,
                'decodeEntities'=>true
            ),
            'sql'                     => "varchar(255) BINARY NOT NULL default ''"
        ),
        'approved' => array
        (
            'exclude'                 => true,
            'inputType'               => 'select',
            'options'                 => ['1','0'],
            'reference'               => &$GLOBALS['TL_LANG']['REF']['wa_approval'],
            'eval'                    => array('tl_class'=>'w50 m12', 'includeBlankOption' => true, 'blankOptionLabel' => &$GLOBALS['TL_LANG']['MSC']['wa_approval_pending']),
            'sql'                     => "char(1) NOT NULL default '1'"
        ),
        'approved_on' => array
        (
            'exclude'                 => true,
            'inputType'               => 'text',
            'eval'                    => array('rgxp' => 'datim', 'datepicker' => true, 'tl_class' => 'clr w50 wizard'),
            'sql'                     => "int(10) unsigned NOT NULL default '0'"
        ),
        'checked_in' => array
        (
            'exclude'                 => true,
            'inputType'               => 'checkbox',
            'eval'                    => array('tl_class'=>'w50 m12'),
            'sql'                     => "char(1) NOT NULL default ''"
        ),
        'checked_in_on' => array
        (
            'exclude'                 => true,
            'inputType'               => 'text',
            'eval'                    => array('rgxp' => 'datim', 'datepicker' => true, 'tl_class' => 'clr w50 wizard'),
            'sql'                     => "int(10) unsigned NOT NULL default '0'"
        ),
        'behaelter_numbers' => array
        (
            'exclude'                 => true,
            'inputType'               => 'multiColumnWizard',
            'eval'                    => array(
                'tl_class' => 'clr',
                'columnFields' => array
                (
                    'behaelter' => array
                    (
                        'label' => &$GLOBALS['TL_LANG']['MSC']['wa_behaelter_number'],
                        'inputType' => 'text',
                        'eval' => array('style' => 'width:200px', 'mandatory' => true, 'rgxp' => 'natural')
                    ),
                    'member' => array
                    (
                        'label' => &$GLOBALS['TL_LANG']['MSC']['wa_member_number'],
                        'inputType' => 'text',
                        'eval' => array('style' => 'width:200px', 'rgxp' => 'natural')
                    )
                )
            ),
            'sql'                     => "text NULL"
        ),
    )
);
