<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\Model;

use Contao\Date;
use Contao\Model;

class WeinanlieferungReservationModel extends Model
{
    /**
     * Table name
     * @var string
     */
    protected static $strTable = 'tl_vr_wa_reservation';

    public static function findAllFuture(array $arrOptions=array())
    {
        $t = static::$strTable;
        $time = Date::floorToMinute();

        return static::findBy(array("pid IN (SELECT tl_vr_wa_slot.id FROM tl_vr_wa_slot WHERE tl_vr_wa_slot.id=tl_vr_wa_reservation.pid AND tl_vr_wa_slot.time >= ?)"), $time, $arrOptions);
    }
}
