<?php

/**
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

use Contao\DC_Table;
use Contao\DataContainer;

$GLOBALS['TL_DCA']['tl_vr_wa_standort'] = array
(
    // Config
    'config' => array
    (
        'dataContainer'    => DC_Table::class,
        'ctable'           => array('tl_vr_wa_slot'),
        'enableVersioning' => true,
        'sql'              => array
        (
            'keys' => array
            (
                'id'  => 'primary'
            )
        )
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode'                    => DataContainer::MODE_SORTABLE,
            'fields'                  => array('title'),
            'flag'                    => DataContainer::SORT_INITIAL_LETTER_ASC,
            'panelLayout'             => 'sort,search,limit'
        ),
        'label' => array(
            'fields'                  => array('title'),
            'format'                  => '%s'
        ),
        'global_operations' => array
        (
            'rebsorte' => array
            (
                'href'                => 'table=tl_vr_wa_rebsorte',
                'class'               => 'header_rebsorte',
            ),
            'leseart' => array
            (
                'href'                => 'table=tl_vr_wa_leseart',
                'class'               => 'header_leseart',
            ),
            'lage' => array
            (
                'href'                => 'table=tl_vr_wa_lage',
                'class'               => 'header_lage',
            ),
            'all' => array
            (
                'href'                => 'act=select',
                'class'               => 'header_edit_all',
                'attributes'          => 'onclick="Backend.getScrollOffset()" accesskey="e"'
            )
        ),
        'operations' => array
        (
            'edit' => array
            (
                'href'                => 'table=tl_vr_wa_slot',
                'icon'                => 'edit.gif',
            ),
            'editheader' => array
            (
                'href'                => 'table=tl_vr_wa_standort&amp;act=edit',
                'icon'                => 'header.svg'
            ),
            'copy' => array
            (
                'href'                => 'act=paste&amp;mode=copy',
                'icon'                => 'copy.svg'
            ),
            'cut' => array
            (
                'href'                => 'act=paste&amp;mode=cut',
                'icon'                => 'cut.svg',
                'attributes'          => 'onclick="Backend.getScrollOffset()"'
            ),
            'delete' => array
            (
                'href'                => 'act=delete',
                'icon'                => 'delete.gif',
            ),
            'show' => array
            (
                'icon'                => 'show.gif',
            ),
        )
    ),

    // Palettes
    'palettes' => array
    (
        'default' => '{title_legend},title'
    ),

    // Subpalettes
    'subpalettes' => array
    (
    ),

    // Fields
    'fields' => array
    (
        'id' => array
        (
            'sql'                     => "int(10) unsigned NOT NULL auto_increment"
        ),
        'tstamp' => array
        (
            'sql'                     => "int(10) unsigned NOT NULL default 0"
        ),
        'title' => array
        (
            'exclude'                 => true,
            'sorting'                 => true,
            'flag'                    => DataContainer::SORT_INITIAL_LETTER_ASC,
            'inputType'               => 'text',
            'eval'                    => array
            (
                'mandatory' => true,
                'maxlength' => 255
            ),
            'sql'                     => "varchar(255) NOT NULL default ''"
        )
    )
);
