<?php

declare(strict_types=1);

/*
* This file is part of contao-weinanlieferung-bundle.
*
* (c) vonRotenberg
*
* @license commercial
*/

namespace vonRotenberg\WeinanlieferungBundle\Cron;

use Contao\CoreBundle\Monolog\ContaoContext;
use Contao\CoreBundle\ServiceAnnotation\CronJob;
use Contao\MemberModel;
use Doctrine\DBAL\Connection;
use Psr\Log\LoggerInterface;
use Psr\Log\LogLevel;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use vonRotenberg\WeinanlieferungBundle\Event\CheckInCompletedEvent;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungReservationModel;

class AutoCheckInJob
{
    /** @var LoggerInterface */
    private $logger;

    /** @var Connection */
    private $db;

    private $eventDispatcher;


    public function __construct(Connection $db, LoggerInterface $logger, EventDispatcherInterface $eventDispatcher)
    {
        $this->logger = $logger;
        $this->db = $db;
        $this->eventDispatcher = $eventDispatcher;
    }

    public function __invoke(string $scope)
    {
        $intThreshold = strtotime('+5 minutes');
        $strDefaultNumber = '9999';

        $Reservations = WeinanlieferungReservationModel::findFutureBy([
            "approved = '1'",
            "checked_in = ''",
            "? >= (SELECT tl_vr_wa_slot.time FROM tl_vr_wa_slot WHERE tl_vr_wa_slot.id=tl_vr_wa_reservation.pid)"
        ],[$intThreshold]);

        if ($Reservations === null) {
            return;
        }

        foreach ($Reservations as $reservation) {
            $reservation = $reservation->current();

            $memberModel = MemberModel::findById($reservation->uid);

            if (null === $memberModel) {
                $this->logger->log(
                    LogLevel::ERROR,
                    sprintf('Could not find member with ID: %s', $reservation->uid),
                    ['contao' => new ContaoContext(__METHOD__, 'AUTO_CHECK_IN')]
                );
                continue;
            }

            $time = time();
            $reservation->checked_in = '1';
            $reservation->checked_in_on = $time;

            $arrBehaelterNumbers = [];
            for ($i = 1; $i <= $reservation->unit_amount; $i++) {
                $arrBehaelterNumbers[] = [
                    'behaelter' => $strDefaultNumber,
                    'member' => $memberModel->memberno
                ];
            }

            $reservation->behaelter_numbers = json_encode($arrBehaelterNumbers);
            $reservation->save();

            $event = new CheckInCompletedEvent($reservation->row(), $reservation);
            $this->eventDispatcher->dispatch($event, CheckInCompletedEvent::NAME);
        }
    }
}
