<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\EventListener\DataContainer;

use Contao\CoreBundle\DataContainer\PaletteManipulator;
use Contao\CoreBundle\ServiceAnnotation\Callback;
use Contao\DataContainer;
use Doctrine\DBAL\Connection;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Contracts\Translation\TranslatorInterface;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungAttributeGroupModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungAttributeModel;

class WeinanlieferungAttributeContainerListener
{
    /** @var Connection */
    protected $db;

    /** @var TranslatorInterface */
    protected $translator;

    /** @var RequestStack */
    protected $requestStack;

    public function __construct(Connection $db, TranslatorInterface $translator, RequestStack $requestStack)
    {
        $this->db = $db;
        $this->translator = $translator;
        $this->requestStack = $requestStack;
    }


    /**
     * @Callback(table="tl_vr_wa_attribute", target="config.onload")
     */
    public function onLoadCallback(DataContainer $dc)
    {
        if (null === $dc || !$dc->id || 'edit' !== $this->requestStack->getCurrentRequest()->query->get('act')) {
            return;
        }

        if (($attribute = WeinanlieferungAttributeModel::findByPk($dc->id)) === null || ($group = $attribute->getRelated('pid')) === null)
        {
            return;
        }

        if ($group->type == 'text')
        {
            PaletteManipulator::create()
                ->addField('description','title')
                ->applyToPalette('default', 'tl_vr_wa_attribute');
        }
    }
}
