<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\Controller\Frontend\Module;

use Contao\Controller;
use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\Exception\ResponseException;
use Contao\CoreBundle\InsertTag\InsertTagParser;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\Date;
use Contao\FrontendUser;
use Contao\ModuleModel;
use Contao\PageModel;
use Contao\StringUtil;
use Contao\System;
use Contao\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungLeseartModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungRebsorteModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungReservationModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungSlotsModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungStandortModel;

/**
 * @FrontendModule(WeinanlieferungSlotsListModuleController::TYPE, category="miscellaneous")
 */
class WeinanlieferungSlotsListModuleController extends AbstractFrontendModuleController
{
    public const TYPE = 'wa_slots_list';

    private $insertTagParser;

    public function __construct(InsertTagParser $insertTagParser)
    {
        $this->insertTagParser = $insertTagParser;
    }


    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        global $objPage;
        $standortIds = StringUtil::deserialize($model->vr_wa_standortId);
        $arrData = $template->getData();
        $arrOptions = [];

        // Add filter values
        if (!empty($_GET['filter_kapazitaet']))
        {
            $arrData['filter']['kapazitaet']['selected'] = $_GET['filter_kapazitaet'];
            $arrOptions['column'][] = '(SELECT tl_vr_wa_slot.behaelter - IFNULL(SUM(tl_vr_wa_reservation.behaelter),0) FROM tl_vr_wa_reservation WHERE tl_vr_wa_reservation.pid = tl_vr_wa_slot.id) >= ?';
            $arrOptions['value'][] = $_GET['filter_kapazitaet'];
        }
        if (!empty($_GET['filter_standort']))
        {
            $arrData['filter']['standort']['selected'] = $_GET['filter_standort'];
            $arrOptions['column'][] = 'pid = ?';
            $arrOptions['value'][] = $_GET['filter_standort'];
        }
        if (!empty($_GET['filter_sorte']) && !empty($_GET['filter_leseart']))
        {
            $arrData['filter']['sorte']['selected'] = $_GET['filter_sorte'];
            $arrData['filter']['leseart']['selected'] = $_GET['filter_leseart'];
            $arrOptions['column'][] = "sorten REGEXP('\"sorte\";s:[0-9]+:\"" . intval($_GET['filter_sorte']) . "\"[^\}]+\"leseart\";s:[0-9]+:\"" . intval($_GET['filter_leseart']) . "\"')";
        } else {
            if (!empty($_GET['filter_sorte']))
            {
                $arrData['filter']['sorte']['selected'] = $_GET['filter_sorte'];
                $arrOptions['column'][] = "sorten REGEXP('\"sorte\";s:[0-9]+:\"" . intval($_GET['filter_sorte']) . "\"')";
            }
            if (!empty($_GET['filter_leseart']))
            {
                $arrData['filter']['leseart']['selected'] = $_GET['filter_leseart'];
                $arrOptions['column'][] = "sorten REGEXP('\"leseart\";s:[0-9]+:\"" . intval($_GET['filter_leseart']) . "\"')";
            }
        }

        $arrData['filter']['kapazitaet']['options'] = range(1,30);

        if (($Standorte = WeinanlieferungStandortModel::findBy(["id IN (".implode(',',$standortIds).")"],null,['order'=>'title ASC'])) !== null)
        {
            $arrData['filter']['standort']['options'] = array_combine($Standorte->fetchEach('id'),$Standorte->fetchEach('title'));
        }

        if (($Sorten = WeinanlieferungRebsorteModel::findAll(['order'=>'title ASC'])) !== null)
        {
            $arrData['filter']['sorte']['options'] = array_combine($Sorten->fetchEach('id'),$Sorten->fetchEach('title'));
        }

        if (($Leseart = WeinanlieferungLeseartModel::findAll(['order'=>'title ASC'])) !== null)
        {
            $arrData['filter']['leseart']['options'] = array_combine($Leseart->fetchEach('id'),$Leseart->fetchEach('title'));
        }

        // Get available slots
        if (($slots = WeinanlieferungSlotsModel::findMultiplePublishedByPids($standortIds,$arrOptions)) !== null)
        {
            /** @var WeinanlieferungSlotsModel $slot */
            foreach ($slots as $slot)
            {
                $day = new Date($slot->date);
                $arrSorten = [];
                $arrErnteart = [];
                $intAvailableBehaelter = $slot->getAvailableBehaelter();

                $Sorten = StringUtil::deserialize($slot->sorten, true);
                foreach ($Sorten as $sorte)
                {
                    $objSorte = WeinanlieferungRebsorteModel::findByPk($sorte['sorte']);
                    $objLeseart = WeinanlieferungLeseartModel::findByPk($sorte['leseart']);
                    $arrSorten[] = ($objSorte !== null ? $objSorte->title : '') . ' ' . ($objLeseart !== null ? $objLeseart->title : '');
                }

                if ($slot->ernteart !== null)
                {
                    foreach (explode(',', $slot->ernteart) as $ernteart)
                    {
                        $arrErnteart[] = $GLOBALS['TL_LANG']['REF']['wa_ernteart'][$ernteart] ?? $ernteart;
                    }
                }

                $strStandort = '';
                if (($Standort = $slot->getRelated('pid')) !== null)
                {
                    $strStandort = $Standort->title;
                }

                $strLage = '';
                if (($Lage = $slot->getRelated('lage')) !== null)
                {
                    $strLage = $Lage->title;
                }

                $arrData['days'][$day->dayBegin][] = array_merge($slot->row(),[
                    'anmerkungen' => $slot->anmerkungen ? StringUtil::substr(strip_tags($slot->anmerkungen),110) : '',
                    'standort' => $strStandort,
                    'lage' => $strLage,
                    'sorte' => $arrSorten,
                    'ernteart' => $arrErnteart,
                    'behaelterAvailable' => $intAvailableBehaelter,
                    'buchbar' => (boolean) $intAvailableBehaelter,
                    'gebucht' => (boolean) WeinanlieferungReservationModel::countBy(["uid = ?","pid = ?"],[FrontendUser::getInstance()->id,$slot->id])
                ]);
            }
        }

        // Add page URL
        if ($objPage instanceof PageModel)
        {
            $arrData['pageUrl'] = $objPage->getFrontendUrl();
        }

        $template->setData($arrData);

        // Handle ajax
        if ($request->headers->get('VR-Ajax') == 'WaSlotsModule')
        {
            throw new ResponseException(new Response($this->insertTagParser->replace($template->parse())));
        }

        return $template->getResponse();
    }

}
