<?php

/**
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

use Contao\DC_Table;
use Contao\DataContainer;

$GLOBALS['TL_DCA']['tl_vr_wa_slot'] = array
(

    // Config
    'config' => array
    (
        'dataContainer'    => DC_Table::class,
        'ptable'           => 'tl_vr_wa_standort',
        'sql'              => array
        (
            'keys' => array
            (
                'id' => 'primary',
                'pid' => 'index'
            )
        )
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => DataContainer::MODE_PARENT,
            'fields' => array('time'),
            'headerFields' => array('title'),
//            'disableGrouping' => true,
            'panelLayout' => 'filter;sort,limit',
        ),
        'global_operations' => array
        (
            'all' => array
            (
                'href'                => 'act=select',
                'class'               => 'header_edit_all',
                'attributes'          => 'onclick="Backend.getScrollOffset()" accesskey="e"'
            )
        ),
        'operations' => array
        (
            'edit' => array
            (
                'href'                => 'act=edit',
                'icon'                => 'edit.gif',
            ),
            'copy' => array
            (
                'href'                => 'act=paste&amp;mode=copy',
                'icon'                => 'copy.svg'
            ),
            'cut' => array
            (
                'href'                => 'act=paste&amp;mode=cut',
                'icon'                => 'cut.svg',
                'attributes'          => 'onclick="Backend.getScrollOffset()"'
            ),
            'delete' => array
            (
                'href'                => 'act=delete',
                'icon'                => 'delete.gif',
            ),
            'toggle' => array
            (
                'href'                => 'act=toggle&amp;field=buchbar',
                'icon'                => 'visible.svg',
                'showInHeader'        => true
            ),
            'show' => array
            (
                'icon'                => 'show.gif',
            ),
        )
    ),

    // Palettes
    'palettes' => array
    (
        '__selector__' => array('addEnclosure'),
        'default' => '{time_legend},date,time;{type_legend},behaelter,leseart,sorte;{info_legend},anmerkungen,addEnclosure;{booking_legend},buchbar,buchbar_bis'
    ),

    // Subpalettes
    'subpalettes' => array
    (
        'addEnclosure' => 'enclosure'
    ),

    // Fields
    'fields' => array
    (
        'id'          => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment"
        ),
        'pid'         => array
        (
            'foreignKey' => 'tl_vr_wa_standort.title',
            'sql'        => "int(10) unsigned NOT NULL default '0'",
            'relation'   => array('type' => 'belongsTo', 'load' => 'lazy')
        ),
        'tstamp'      => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'"
        ),
        'date'        => array
        (
            'exclude'   => true,
            'inputType' => 'text',
            'eval'      => array('rgxp' => 'date', 'mandatory' => true, 'datepicker' => true, 'tl_class' => 'w50 wizard'),
            'sql'       => "int(10) unsigned NULL"
        ),
        'time'        => array
        (
            'exclude'   => true,
            'default'   => time(),
            'filter'    => true,
            'sorting'   => true,
            'flag'      => DataContainer::SORT_MONTH_DESC,
            'inputType' => 'text',
            'eval'      => array('rgxp' => 'time', 'mandatory' => true, 'tl_class' => 'w50'),
            'sql'       => "int(10) NULL"
        ),
        'behaelter'   => array
        (
            'exclude'   => true,
            'inputType' => 'select',
            'options_callback'   => function () {
                $range = [];
                for ($i = 1; $i <= 30; $i++)
                {
                    $range[] = $i;
                }
                return $range;
            },
            'eval'      => array('rgxp' => 'natural', 'mandatory' => true, 'includeBlankOption' => true, 'tl_class' => 'w50'),
            'sql'       => "smallint(3) unsigned NOT NULL default 0"
        ),
        'leseart'     => array
        (
            'exclude'   => true,
            'inputType' => 'select',
            'options'   => [],
            'reference' => &$GLOBALS['TL_LANG']['MSC']['leseart'],
            'eval'      => array('rgxp' => 'natural', 'mandatory' => false, 'includeBlankOption' => true, 'tl_class' => 'clr w50'),
            'sql'       => "varchar(32) NOT NULL default ''"
        ),
        'sorte'       => array
        (
            'exclude'   => true,
            'inputType' => 'select',
            'foreignKey'   => 'tl_vr_wa_rebsorte.title',
            'eval'      => array('rgxp' => 'natural', 'mandatory' => false, 'multiple'=>true,'chosen'=>true,'includeBlankOption' => true, 'tl_class' => 'w50','csv'=>','),
            'sql'       => "blob NULL"
        ),
        'anmerkungen' => array
        (
            'exclude'                 => true,
            'search'                  => true,
            'inputType'               => 'textarea',
            'eval'                    => array('rte'=>'tinyMCE', 'tl_class'=>'clr'),
            'sql'                     => "text NULL"
        ),
        'addEnclosure' => array
        (
            'exclude'                 => true,
            'inputType'               => 'checkbox',
            'eval'                    => array('submitOnChange'=>true),
            'sql'                     => "char(1) NOT NULL default ''"
        ),
        'enclosure' => array
        (
            'exclude'                 => true,
            'inputType'               => 'fileTree',
            'eval'                    => array('multiple'=>true, 'fieldType'=>'checkbox', 'filesOnly'=>true, 'isDownloads'=>true, 'extensions'=>Config::get('allowedDownload'), 'mandatory'=>true, 'isSortable'=>true),
            'sql'                     => "blob NULL"
        ),
        'buchbar'     => array
        (
            'exclude'   => true,
            'toggle'    => true,
            'filter'    => true,
            'flag'      => DataContainer::SORT_INITIAL_LETTER_DESC,
            'inputType' => 'checkbox',
            'eval'      => array('doNotCopy' => true),
            'sql'       => "char(1) NOT NULL default ''"
        ),
        'buchbar_bis' => array
        (
            'exclude'   => true,
            'inputType' => 'text',
            'eval'      => array('rgxp' => 'datim', 'mandatory' => true, 'datepicker' => true, 'tl_class' => 'clr w50 wizard'),
            'sql'       => "int(10) unsigned NULL"
        ),
    )
);
