<?php
/**
 * OBG Customizations
 *
 * Copyright (c) 2021 vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\RealEstateListingBundle\Controller\FrontendModule;

use Contao\CoreBundle\DependencyInjection\Attribute\AsFrontendModule;
use Contao\CoreBundle\Twig\FragmentTemplate;
use vonRotenberg\RealEstateListingBundle\Model\RealEstateAssetsModel;
use Contao\Controller;
use Contao\ModuleModel;
use Contao\PageModel;
use Contao\StringUtil;
use Contao\System;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Contracts\Translation\TranslatorInterface;

#[AsFrontendModule(RealEstateAssetsAdController::TYPE, category: 'miscellaneous')]
class RealEstateAssetsAdController extends RealEstateAssetsModuleController
{
    public const TYPE = 'vr_re_assets_ad';

    /**
     * @var TranslatorInterface
     */
    protected $translator;

    protected function getResponse(FragmentTemplate $template, ModuleModel $model, Request $request): Response
    {
        $this->translator = System::getContainer()->get('translator');
        Controller::loadLanguageFile(RealEstateAssetsModel::getTable());

        if (($assetsCount = $this->countRealEstateAssets(StringUtil::deserialize($model->vr_re_categories))) < 1)
        {
            return new Response();
        }

        $jumpTo = PageModel::findByPk($model->jumpTo);

        $template->listUrl = $jumpTo !== null ? $jumpTo->getFrontendUrl() : null;

        return $template->getResponse();
    }

}
