<?php

/**
 * OBG Customizations
 *
 * Copyright (c) 2021 vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\RealEstateListingBundle\EventListener;

use Contao\CoreBundle\ServiceAnnotation\Callback;
use Contao\DataContainer;
use vonRotenberg\RealEstateListingBundle\Model\ManagedPropertyModel;

class ReManagedPropertiesContainerListener
{
    /**
     * @Callback(table="tl_vr_re_managedProperties", target="config.onsubmit")
     */
    public function setCoordinatesToAssets(DataContainer $dc)
    {
        if (!$dc->id || ($Property = ManagedPropertyModel::findByPk($dc->id)) === null) {
            return;
        }

        $this->db->update('tl_vr_real_estate_assets', ['managedPropertyId' => $dc->id], ['geox' => $Property->geox, 'geoy' => $Property->geoy]);
    }
}
