<?php

/**
 * OBG Customizations
 *
 * Copyright (c) 2021 vonRotenberg
 *
 * @license commercial
 */

use Contao\DC_Table;
use Contao\DataContainer;

$GLOBALS['TL_DCA']['tl_vr_real_estate_assets'] = array
(
  // Config
  'config' => array
  (
    'dataContainer'               => DC_Table::class,
    'ptable'                      => 'tl_vr_real_estate_categories',
    'enableVersioning'            => true,
    'switchToEdit'                => true,
    'markAsCopy'                  => 'title',
    'sql' => array
    (
      'keys' => array
      (
        'id' => 'primary',
        'pid' => 'index',
      )
    )
  ),

  // List
  'list' => array
  (
    'sorting' => array
    (
      'mode'                    => DataContainer::MODE_PARENT,
      'fields'                  => array('address','assetNo','title'),
      'flag'                    => DataContainer::SORT_INITIAL_LETTER_ASC,
      'headerFields'            => array('title'),
      'disableGrouping'         => false,
      'child_record_callback'   => function($arrRow)
      {
        $time = time();
        $isUnpublished = !$arrRow['published'] || ($arrRow['stop'] && $arrRow['stop'] <= time());
        return '<div class="tl_content_left"><div class="estable"><div class="estable_cell estable_w25">' . $arrRow['title'] . ' <div class="esc_grey">[' . $arrRow['assetNo'] . ']</div></div><div class="estable_cell estable_w10" style="text-align:right; padding-right: 10px;">' . number_format($arrRow['livingSpace'],2, ',', '') . ' m²</div>'. (!$isUnpublished ? '<div class="estable_cell esc_blue">Veröffentlicht<br>ab: ' . ($time < $arrRow['start'] ? \Contao\Date::parse(\Contao\Date::getNumericDatimFormat(),$arrRow['start']) : 'sofort') . '<br>bis: '. ($time < $arrRow['stop'] ? \Contao\Date::parse(\Contao\Date::getNumericDatimFormat(),$arrRow['stop']) : 'endlos') .'</div>' : '') .'</div></div>';
      },
      'panelLayout'             => 'filter;sort,search,limit'
    ),
    'label' => array
    (
      'fields'                  => array('title'),
    ),
    'global_operations' => array
    (
      'all' => array
      (
        'href'                => 'act=select',
        'class'               => 'header_edit_all',
        'attributes'          => 'onclick="Backend.getScrollOffset()" accesskey="e"'
      )
    ),
    'operations' => array
    (
      'edit' => array
      (
        'href'                => 'act=edit',
        'icon'                => 'edit.svg'
      ),
      'copy' => array
      (
        'href'                => 'act=paste&amp;mode=copy',
        'icon'                => 'copy.svg'
      ),
      'cut' => array
      (
        'href'                => 'act=paste&amp;mode=cut',
        'icon'                => 'cut.svg'
      ),
      'delete' => array
      (
        'href'                => 'act=delete',
        'icon'                => 'delete.svg',
        'attributes'          => 'onclick="if(!confirm(\'' . ($GLOBALS['TL_LANG']['MSC']['deleteConfirm'] ?? null) . '\'))return false;Backend.getScrollOffset()"'
      ),
      'show' => array
      (
        'href'                => 'act=show',
        'icon'                => 'show.svg'
      )
    )
  ),

  // Palettes
  'palettes' => array
  (
    '__selector__'                => array('availability'),
    'default'                     => '{title_legend},title,assetNo,address,floor,city;{availability_legend},availability;{misc_legend},description;{basic_data_legend},livingSpace,numberOfRooms,rent,coldRent,advanceOperatingCosts,constructionYear,cooperativeShares;{features_legend},features,heatingType,energyPassType,energyConsumption;{images_legend},gallerySRC,floorPlansSRC;{publish_legend},published,start,stop',
  ),

  // Subpalettes
  'subpalettes' => array
  (
    'availability_from'              => 'availableFrom',
  ),

  // Fields
  'fields' => array
  (
    'id' => array
    (
      'sql'                     => "int(10) unsigned NOT NULL auto_increment"
    ),
    'pid' => array
    (
      'sql'                     => "int(10) unsigned NOT NULL"
    ),
    'tstamp' => array
    (
      'sql'                     => "int(10) unsigned NOT NULL default 0"
    ),
    'title' => array
    (
      'exclude'                 => true,
      'flag'                    => DataContainer::SORT_INITIAL_LETTER_ASC,
      'default'                 => '2 Zimmer Wohnung',
      'inputType'               => 'text',
      'eval'                    => array('mandatory'=>true, 'maxlength'=>255, 'tl_class'=>'w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'city' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'default'                 => 'Kehl',
      'eval'                    => array('mandatory'=>true, 'maxlength'=>255, 'tl_class'=>'w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'address' => array
    (
      'exclude'                 => true,
      'filter'                  => true,
      'inputType'               => 'text',
      'eval'                    => array('mandatory'=>false, 'maxlength'=>255, 'tl_class'=>'w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'floor' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('mandatory'=>false, 'maxlength'=>255, 'tl_class'=>'w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'assetNo' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('mandatory'=>true, 'maxlength'=>8, 'tl_class'=>'w50'),
      'sql'                     => "varchar(8) NOT NULL default ''"
    ),
    'livingSpace' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('mandatory'=>false, 'rgxp'=>'float', 'maxlength'=>6, 'tl_class'=>'w50'),
      'sql'                     => "float(5,2) unsigned NOT NULL default 0.00"
    ),
    'numberOfRooms' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('mandatory'=>false, 'rgxp'=>'natural', 'maxlength'=>2, 'tl_class'=>'w50'),
      'sql'                     => "tinyint(2) unsigned NOT NULL default 0"
    ),
    'rent' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('mandatory'=>false, 'rgxp'=>'currency', 'maxlength'=>15, 'tl_class'=>'w50'),
      'sql'                     => "decimal(12,2) NOT NULL default '0.00'"
    ),
    'coldRent' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('mandatory'=>false, 'rgxp'=>'currency', 'maxlength'=>15, 'tl_class'=>'w50'),
      'sql'                     => "decimal(12,2) NOT NULL default '0.00'"
    ),
    'advanceOperatingCosts' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('mandatory'=>false, 'rgxp'=>'currency', 'maxlength'=>15, 'tl_class'=>'w50'),
      'sql'                     => "decimal(12,2) NOT NULL default '0.00'"
    ),
    'heatingCosts' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('mandatory'=>false, 'rgxp'=>'currency', 'maxlength'=>15, 'tl_class'=>'w50'),
      'sql'                     => "decimal(12,2) NOT NULL default '0.00'"
    ),
    'condition' => array
    (
      'exclude'                 => true,
      'inputType'               => 'select',
      'options'                 => array
      (
        'new',
        'renovated',
        'partially_renovated',
        'maintained',
      ),
      'reference'               => &$GLOBALS['TL_LANG']['REF']['re_condition'],
      'eval'                    => array('mandatory'=>false, 'includeBlankOption'=>true, 'tl_class'=>'w50'),
      'sql'                     => "varchar(32) NOT NULL default ''"
    ),
    'constructionYear' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('mandatory'=>false, 'rgxp'=>'digit', 'maxlength'=>4, 'tl_class'=>'w50'),
      'sql'                     => "varchar(4) NOT NULL default ''"
    ),
    'cooperativeShares' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('mandatory'=>false, 'rgxp'=>'natural', 'maxlength'=>2, 'tl_class'=>'w50'),
      'sql'                     => "tinyint(2) unsigned NULL"
    ),
    'features' => array
    (
      'exclude'                 => true,
      'inputType'               => 'checkbox',
      'options'                 => array
      (
        'kitchen',
        'bathroom',
        'guestToilet',
        'garret',
        'balcony',
        'loggia',
        'gardenShare',
        'basementRoom',
        'garage',
        'carport',
        'cable'
      ),
      'reference'               => &$GLOBALS['TL_LANG']['REF']['re_features'],
      'eval'                    => array('mandatory'=>false, 'multiple'=>true, 'tl_class'=>'w50'),
      'sql'                     => "blob NULL"
    ),
    'heatingType' => array
    (
      'exclude'                 => true,
      'inputType'               => 'select',
      'options'                 => array
      (
        'geh',
        'fw',
        'zh',
        'gzh',
        'nsp',
        'go'
      ),
      'reference'               => &$GLOBALS['TL_LANG']['REF']['re_heatingType'],
      'eval'                    => array('mandatory'=>false, 'includeBlankOption'=>true, 'tl_class'=>'w50'),
      'sql'                     => "varchar(16) NOT NULL default ''"
    ),
    'energyPassType' => array
    (
      'exclude'                 => true,
      'inputType'               => 'select',
      'options'                 => array
      (
        'eav',
        'eab',
      ),
      'reference'               => &$GLOBALS['TL_LANG']['REF']['re_energyPassType'],
      'eval'                    => array('mandatory'=>false, 'includeBlankOption'=>true, 'tl_class'=>'clr w50'),
      'sql'                     => "varchar(16) NOT NULL default ''"
    ),
    'energyConsumption' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('mandatory'=>false, 'rgxp'=>'digit', 'maxlength'=>6, 'tl_class'=>'w50'),
      'sql'                     => "float(6,2) NOT NULL default 0.00"
    ),
    'gallerySRC' => array
    (
      'exclude'                 => true,
      'inputType'               => 'fileTree',
      'eval'                    => array('mandatory'=>true,'filesOnly'=>true, 'fieldType'=>'checkbox', 'multiple'=>true, 'tl_class'=>'clr','orderField'=>'orderSRC','files'=>true, 'extensions'=>\Contao\Config::get('validImageTypes'),'isGallery'=>true),
      'sql'                     => "blob NULL"
    ),
    'orderSRC' => array
    (
      'label'                   => &$GLOBALS['TL_LANG']['MSC']['sortOrder'],
      'sql'                     => "blob NULL"
    ),
    'floorPlansSRC' => array
    (
      'exclude'                 => true,
      'inputType'               => 'fileTree',
      'eval'                    => array('filesOnly'=>true, 'fieldType'=>'checkbox', 'multiple'=>true, 'tl_class'=>'clr','orderField'=>'floorPlansOrderSRC','files'=>true, 'extensions'=>\Contao\Config::get('validImageTypes'),'isGallery'=>true),
      'sql'                     => "blob NULL"
    ),
    'floorPlansOrderSRC' => array
    (
      'label'                   => &$GLOBALS['TL_LANG']['MSC']['sortOrder'],
      'sql'                     => "blob NULL"
    ),
    'availability' => array
    (
      'exclude'                 => true,
      'inputType'               => 'radio',
      'options'                 => array
      (
        'immediately',
        'from'
      ),
      'reference'               => &$GLOBALS['TL_LANG']['REF']['re_availability'],
      'eval'                    => array('mandatory'=>false, 'tl_class'=>'w50', 'submitOnChange'=>true),
      'sql'                     => "varchar(16) NOT NULL default 'immediately'"
    ),
    'availableFrom' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('mandatory'=>false, 'rgxp'=>'date', 'datepicker'=>true, 'tl_class'=>'w50 wizard'),
      'sql'                     => "int(10) unsigned NULL"
    ),
    'description' => array
    (
      'exclude'                 => true,
      'inputType'               => 'textarea',
      'eval'                    => array('mandatory'=>false, 'rte'=>'tinyMCE', 'helpwizard'=>true, 'tl_class'=>'clr'),
      'explanation'             => 'insertTags',
      'sql'                     => "mediumtext NULL"
    ),
    'published' => array
    (
      'exclude'                 => true,
      'filter'                  => true,
      'inputType'               => 'checkbox',
      'eval'                    => array('doNotCopy'=>true),
      'sql'                     => "char(1) NOT NULL default ''"
    ),
    'start' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('rgxp'=>'datim', 'datepicker'=>true, 'tl_class'=>'w50 wizard'),
      'sql'                     => "varchar(10) NOT NULL default ''"
    ),
    'stop' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('rgxp'=>'datim', 'datepicker'=>true, 'tl_class'=>'w50 wizard'),
      'sql'                     => "varchar(10) NOT NULL default ''"
    )
  )
);
