<?php

/**
 * OBG Customizations
 *
 * Copyright (c) 2021 vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\RealEstateListingBundle\EventListener;

use Contao\CoreBundle\ServiceAnnotation\Callback;
use Contao\DataContainer;
use Doctrine\DBAL\Connection;
use vonRotenberg\RealEstateListingBundle\Model\ManagedPropertyModel;

class RealEstateAssetsContainerListener
{
    private $db;
    public function __construct(Connection $db)
    {
        $this->db = $db;
    }

    /**
     * @Callback(table="tl_vr_real_estate_assets", target="fields.managedPropertyId.options")
     */
    public function onAddCustomRegexp(?DataContainer $dc): array
    {
        $arrOptions = [];

        if (($Properties = ManagedPropertyModel::findAllPublished()) !== null)
        {
            foreach ($Properties as $property)
            {
                $arrOptions[$property->city][$property->id] = $property->address . ' [' . $property->city . ']';
            }
        }

        return $arrOptions;
    }

    /**
     * @Callback(table="tl_vr_real_estate_assets", target="config.onsubmit")
     */
    public function setCoordinatesToAsset(DataContainer $dc)
    {
        if (!$dc->id || !$dc->activeRecord->managedPropertyId || ($Property = ManagedPropertyModel::findByPk($dc->activeRecord->managedPropertyId)) === null) {
            return;
        }

        $this->db->update('tl_vr_real_estate_assets', ['geox' => $Property->geox, 'geoy' => $Property->geoy],['id' => $dc->id]);
    }
}
