<?php

/**
 * OBG Customizations
 *
 * Copyright (c) 2021 vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\RealEstateListingBundle\EventListener;

use Contao\CoreBundle\ServiceAnnotation\Callback;
use Contao\DataContainer;
use vonRotenberg\RealEstateListingBundle\Model\ManagedPropertyModel;

class RealEstateAssetsContainerListener
{
  /**
   * @Callback(table="tl_vr_real_estate_assets", target="fields.managedPropertyId.options")
   */
  public function onAddCustomRegexp(?DataContainer $dc): array
    {
      $arrOptions = [];

      if (($Properties = ManagedPropertyModel::findAllPublished()) !== null)
      {
          foreach ($Properties as $property)
          {
              $arrOptions[$property->city][$property->id] = $property->address . ' [' . $property->city . ']';
          }
      }

      return $arrOptions;
    }
}
