<?php

/**
 * OBG Customizations
 *
 * Copyright (c) 2021 vonRotenberg
 *
 * @license commercial
 */

use Contao\DC_Table;
use Contao\DataContainer;

$GLOBALS['TL_DCA']['tl_vr_real_estate_categories'] = array
(
  // Config
  'config' => array
  (
    'dataContainer'               => DC_Table::class,
    'ctable'                      => ['tl_vr_real_estate_assets'],
    'enableVersioning'            => true,
    'sql' => array
    (
      'keys' => array
      (
        'id' => 'primary',
      )
    )
  ),

  // List
  'list' => array
  (
    'sorting' => array
    (
      'mode'                    => DataContainer::MODE_SORTABLE,
      'fields'                  => array('title'),
      'flag'                    => DataContainer::SORT_INITIAL_LETTER_ASC,
      'panelLayout'             => 'filter;sort,search,limit'
    ),
    'label' => array
    (
      'fields'                  => array('title'),
    ),
    'global_operations' => array
    (
      'all' => array
      (
        'href'                => 'act=select',
        'class'               => 'header_edit_all',
        'attributes'          => 'onclick="Backend.getScrollOffset()" accesskey="e"'
      )
    ),
    'operations' => array
    (
      'edit' => array
      (
        'href'                => 'table=tl_vr_real_estate_assets',
        'icon'                => 'bundles/vonrotenbergrealestatelisting/images/icons/icon_assets.svg'
      ),
      'editheader' => array
      (
        'href'                => 'act=edit',
        'icon'                => 'header.svg',
      ),
      'copy' => array
      (
        'href'                => 'act=copy',
        'icon'                => 'copy.svg'
      ),
      'delete' => array
      (
        'href'                => 'act=delete',
        'icon'                => 'delete.svg',
        'attributes'          => 'onclick="if(!confirm(\'' . ($GLOBALS['TL_LANG']['MSC']['deleteConfirm'] ?? null) . '\'))return false;Backend.getScrollOffset()"'
      ),
      'show' => array
      (
        'href'                => 'act=show',
        'icon'                => 'show.svg'
      )
    )
  ),

  // Palettes
  'palettes' => array
  (
    '__selector__'                => array(),
    'default'                     => 'title,description',
  ),

  // Subpalettes
  'subpalettes' => array
  (
  ),

  // Fields
  'fields' => array
  (
    'id' => array
    (
      'sql'                     => "int(10) unsigned NOT NULL auto_increment"
    ),
    'tstamp' => array
    (
      'sql'                     => "int(10) unsigned NOT NULL default 0"
    ),
    'title' => array
    (
      'exclude'                 => true,
      'sorting'                 => true,
      'flag'                    => DataContainer::SORT_INITIAL_LETTER_ASC,
      'inputType'               => 'text',
      'eval'                    => array('mandatory'=>true, 'maxlength'=>255, 'tl_class'=>'w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'description' => array
    (
      'exclude'                 => true,
      'inputType'               => 'textarea',
      'eval'                    => array('mandatory'=>false, 'rte'=>'tinyMCE', 'helpwizard'=>true, 'tl_class'=>'clr'),
      'explanation'             => 'insertTags',
      'sql'                     => "mediumtext NULL"
    )
  )
);
