<?php

/**
 * OBG Customizations
 *
 * Copyright (c) 2021 vonRotenberg
 *
 * @license commercial
 */

use vonRotenberg\RealEstateListingBundle\Controller\FrontendModule\RealEstateAssetsAdController;
use vonRotenberg\RealEstateListingBundle\Controller\FrontendModule\RealEstateAssetsListController;
use vonRotenberg\RealEstateListingBundle\Controller\FrontendModule\RealEstateAssetsReaderController;

$GLOBALS['TL_DCA']['tl_module']['palettes'][RealEstateAssetsListController::TYPE] = '{title_legend},name,headline,type;{real_estate_legend},vr_re_categories,imgSize;{re_reader_legend},jumpTo;{template_legend:hide},customTpl;{protected_legend:hide},protected;{expert_legend:hide},guests,cssID';
$GLOBALS['TL_DCA']['tl_module']['palettes'][RealEstateAssetsAdController::TYPE] = '{title_legend},name,headline,type;{real_estate_legend},vr_re_categories;{re_reader_legend},jumpTo;{template_legend:hide},customTpl;{protected_legend:hide},protected;{expert_legend:hide},guests,cssID';
$GLOBALS['TL_DCA']['tl_module']['palettes'][RealEstateAssetsReaderController::TYPE] = '{title_legend},name,headline,type;{real_estate_legend},imgSize;{re_form_legend},vr_re_formUrl;{re_overview_legend},jumpTo;{template_legend:hide},customTpl;{protected_legend:hide},protected;{expert_legend:hide},guests,cssID';

$GLOBALS['TL_DCA']['tl_module']['fields']['vr_re_categories'] = [
  'exclude'                 => true,
  'inputType'               => 'checkboxWizard',
  'foreignKey'              => 'tl_vr_real_estate_categories.title',
  'eval'                    => array('mandatory'=>true, 'multiple'=>true, 'tl_class'=>'w50'),
  'sql'                     => "blob NULL",
  'relation'                => array('type'=>'hasMany', 'load'=>'lazy')
];

$GLOBALS['TL_DCA']['tl_module']['fields']['vr_re_formUrl'] = [
  'exclude'                 => true,
  'inputType'               => 'text',
  'eval'                    => array('mandatory'=>true, 'rgxp'=>'url', 'decodeEntities'=>true, 'maxlength'=>255, 'tl_class'=>'w50'),
  'sql'                     => "varchar(255) NOT NULL default ''"
];
