<?php

/**
 * OBG Customizations
 *
 * Copyright (c) 2021 vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\RealEstateListingBundle\Model;

use Contao\CoreBundle\File\ModelMetadataTrait;
use Contao\Date;
use Contao\Model;
use Contao\Model\Collection;

/**
 * Reads and writes assets
 *
 * @property string|integer         $id
 * @property string|integer         $tstamp
 * @property string                 $title
 * @property string|null            $description
 *
 * @method static RealEstateAssetsModel|null findById($id, array $opt=array())
 * @method static RealEstateAssetsModel|null findByPk($id, array $opt=array())
 * @method static RealEstateAssetsModel|null findOneBy($col, $val, array $opt=array())
 * @method static RealEstateAssetsModel|null findOneByTstamp($val, array $opt=array())
 * @method static RealEstateAssetsModel|null findOneByTitle($val, array $opt=array())
 * @method static RealEstateAssetsModel|null findOneByDescription($val, array $opt=array())
 *
 * @method static Collection|RealEstateAssetsModel[]|RealEstateAssetsModel|null findByTstamp($val, array $opt=array())
 * @method static Collection|RealEstateAssetsModel[]|RealEstateAssetsModel|null findByTitle($val, array $opt=array())
 * @method static Collection|RealEstateAssetsModel[]|RealEstateAssetsModel|null findByDescription($val, array $opt=array())
 * @method static Collection|RealEstateAssetsModel[]|RealEstateAssetsModel|null findMultipleByIds($val, array $opt=array())
 * @method static Collection|RealEstateAssetsModel[]|RealEstateAssetsModel|null findBy($col, $val, array $opt=array())
 * @method static Collection|RealEstateAssetsModel[]|RealEstateAssetsModel|null findAll(array $opt=array())
 *
 * @method static integer countById($id, array $opt=array())
 * @method static integer countByTstamp($val, array $opt=array())
 * @method static integer countByTitle($val, array $opt=array())
 * @method static integer countByDescription($val, array $opt=array())
 *
 * @author Benjamin Roth <https://www.vonrotenberg.de>
 */
class RealEstateCategoriesModel extends Model
{

	/**
	 * Table name
	 * @var string
	 */
	protected static $strTable = 'tl_vr_real_estate_categories';
}
