<?php

/**
 * OBG Customizations
 *
 * Copyright (c) 2021 vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\RealEstateListingBundle\EventListener;

use Contao\CoreBundle\ServiceAnnotation\Callback;
use Contao\DataContainer;
use Doctrine\DBAL\Connection;
use vonRotenberg\RealEstateListingBundle\Model\ManagedPropertyModel;

class ReManagedPropertiesContainerListener
{
    private $db;
    public function __construct(Connection $db)
    {
        $this->db = $db;
    }

    /**
     * @Callback(table="tl_vr_re_managedProperties", target="config.onsubmit")
     */
    public function setCoordinatesToAssets(DataContainer $dc)
    {
        if (!$dc->id || ($Property = ManagedPropertyModel::findByPk($dc->id)) === null) {
            return;
        }
        dump($this->db);

        $this->db->update('tl_vr_real_estate_assets', ['geox' => $Property->geox, 'geoy' => $Property->geoy],['managedPropertyId' => $dc->id]);
    }
}
