<?php


namespace vonRotenberg\RealEstateListingBundle\Twig;

use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

class AppExtension extends AbstractExtension
{
  public function getFilters(): array
  {
    return [
      new TwigFilter('mm2pt', [$this, 'convertMillimeterToPoint']),
      new TwigFilter('imageDataUrl', [$this, 'getImageDataUrl']),
    ];
  }

  public function convertMillimeterToPoint(float $mm): float
  {
    return (float) $mm / 25.4 * 72;
  }

  public function getImageDataUrl(string $path): string
  {
    $type = pathinfo($path, PATHINFO_EXTENSION);
    $data = file_get_contents($path);
    return 'data:image/' . $type . ';base64,' . base64_encode($data);
  }
}
