<?php

declare(strict_types=1);

/*
 * This file is part of memberfiles bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\MemberfilesBundle\EventListener\DataContainer;

use Contao\Backend;
use Contao\BackendUser;
use Contao\Controller;
use Contao\CoreBundle\ServiceAnnotation\Callback;
use Contao\DataContainer;
use Contao\File;
use Contao\Image;
use Contao\Input;
use Contao\StringUtil;
use Contao\System;
use Contao\Date;
use Contao\Config;
use vonRotenberg\MemberfilesBundle\Model\SecureDownloadsModel;

class MemberfilesConfigListener {

    /**
     * @var BackendUser
     */
    protected $User;

    public function __construct()
    {
        $this->User = BackendUser::getInstance();
    }

    /**
     * @Callback(table="tl_memberfiles_config", target="fields.fields.options")
     */
    public function onFieldsOptionsCallback(?DataContainer $dc)
    {
        $return = array('id'=>'ID');

        System::loadLanguageFile('tl_member');
        Controller::loadDataContainer('tl_member');

        foreach ($GLOBALS['TL_DCA']['tl_member']['fields'] as $k=>$v)
        {
            if (is_array($v['label']))
            {
                $return[$k] = $GLOBALS['TL_DCA']['tl_member']['fields'][$k]['label'][0];
            }
        }

        return $return;
    }

    /**
     * @Callback(table="tl_memberfiles_config", target="fields.notification.options")
     */
    public function onNotificationOptionsCallback(?DataContainer $dc)
    {
        $arrChoices = array();
        $objNotifications = \Database::getInstance()->execute("SELECT id,title FROM tl_nc_notification WHERE type='secDownloads_submitted' ORDER BY title");

        while ($objNotifications->next()) {
            $arrChoices[$objNotifications->id] = $objNotifications->title;
        }

        return $arrChoices;
    }

}
