<?php

declare(strict_types=1);

/*
 * This file is part of memberfiles bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace VonRotenberg\MemberfilesBundle\EventListener\DataContainer;

use Contao\BackendUser;
use Contao\CoreBundle\ServiceAnnotation\Callback;
use Contao\System;
use Contao\Date;
use Contao\Config;

class MemberSecureDownloadsListener {

    /**
     * @var BackendUser
     */
    protected $User;
    public function __construct()
    {
        $this->User = BackendUser::getInstance();
    }

    /**
     * @Callback(table="tl_member_secureDownloads", target="list.sorting.child_record")
     */
    public function onChildRecordCallback(array $row)
    {
        $objSecFile = \SecureDownloadsModel::findByPk($row['id']);
        $objFile = $objSecFile->getRelated('uuid');

        return '<div class="tl_content_left">' . ($objFile !== null ? $objFile->name : '') . ' <span style="color:#b3b3b3;padding-left:3px">[' . Date::parse(Config::get('datimFormat'), $row['ctime']) . ']</span></div>';
    }
}
