<?php

/**
 * SecureDownloads for Contao
 *
 * Copyright (c) 2017 Benjamin Roth
 *
 * @license commercial
 */

/**
 * Table tl_member_secureDownloads
 */
$GLOBALS['TL_DCA']['tl_member_secureDownloads'] = array
(

	// Config
	'config' => array
	(
		'dataContainer'             => 'Table',
		'ptable'                    => 'tl_member',
		'closed'                    => true,
		'ondelete_callback'         => array
    (
      array('tl_member_secureDownloads','deleteFileCallback')
    ),
		'sql' => array
		(
			'keys' => array
			(
				'id'  => 'primary',
        'pid' => 'index'
			)
		)
	),

	// List
	'list' => array
	(
		'sorting' => array
		(
      'mode'                  => 4,
      'fields'                => array('ctime'),
      'headerFields'          => array('firstname','lastname', 'username','memberno'),
      'disableGrouping'       => false,
      'flag'                  => 6,
      'panelLayout'           => 'filter;sort,search,limit',
      'child_record_callback' => array('tl_member_secureDownloads','listDownloads')
		),
		'global_operations' => array
		(

		),
		'operations' => array
		(
      'edit' => array
      (
        'label'               => &$GLOBALS['TL_LANG']['tl_member_secureDownloads']['edit'],
        'href'                => 'act=edit',
        'icon'                => 'edit.gif',
        'button_callback'     => array('tl_member_secureDownloads', 'editFile')
),
      'delete' => array
      (
        'label'               => &$GLOBALS['TL_LANG']['tl_member_secureDownloads']['delete'],
        'href'                => 'act=delete',
        'icon'                => 'delete.gif',
        'button_callback'     => array('tl_member_secureDownloads', 'deleteFile')
      ),
      'show' => array
      (
        'label'               => &$GLOBALS['TL_LANG']['tl_member_secureDownloads']['show'],
        'icon'                => 'show.gif',
        'button_callback'     => array('tl_member_secureDownloads', 'showFile')
      ),
		)
	),

	// Palettes
	'palettes' => array
	(
	  'default'                   => '{sec_dl_legend},name'
	),

	// Subpalettes
	'subpalettes' => array
	(
	),

	// Fields
	'fields' => array
	(
		'id' => array
		(
			'sql'                     => "int(10) unsigned NOT NULL auto_increment"
		),
		'pid' => array
		(
			'foreignKey'              => 'tl_member.name',
			'sql'                     => "int(10) unsigned NOT NULL default '0'",
			'relation'                => array('type'=>'belongsTo', 'load'=>'lazy')
		),
    'uuid' => array
    (
      'foreignKey'              => 'tl_files.name',
      'sql'                     => "binary(16) NULL",
      'relation'                => array('type'=>'belongsTo', 'load'=>'eager', 'field'=>'uuid')
    ),
		'tstamp' => array
		(
			'sql'                     => "int(10) unsigned NOT NULL default '0'"
		),
    'ctime' => array
		(
      'label'                   => &$GLOBALS['TL_LANG']['tl_member_secureDownloads']['ctime'],
      'sorting'                 => true,
			'flag'                    => 6,
			'sql'                     => "int(10) unsigned NOT NULL default '0'"
		),
    'name' => array
    (
      'exclude'                 => true,
      'label'                   => &$GLOBALS['TL_LANG']['tl_member_secureDownloads']['name'],
      'sorting'                 => true,
      'flag'                    => 1,
      'inputType'               => 'text',
      'eval'                    => array('mandatory'=>true, 'maxlength'=>255, 'decodeEntities'=>true, 'doNotSaveEmpty'=>true),
      'load_callback' => array
      (
        array('tl_member_secureDownloads', 'getFilename')
      ),
      'save_callback' => array
      (
        array('tl_member_secureDownloads', 'checkFilename')
      ),
//      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    /*'path' => array
    (
      'sql'                     => "varchar(1022) NOT NULL default ''",
    ),*/
    'nc_sent' => array
    (
      'sql'                     => "char(1) NOT NULL default ''"
    ),
	)
);


class tl_member_secureDownloads extends \Backend
{
  /**
   * Import the back end user object
   */
  public function __construct()
  {
    parent::__construct();
    $this->import('BackendUser', 'User');
  }

  public function listDownloads($arrRow)
  {
    $objSecFile = \SecureDownloadsModel::findByPk($arrRow['id']);
    $objFile = $objSecFile->getRelated('uuid');

    return '<div class="tl_content_left">' . ($objFile !== null ? $objFile->name : '') . ' <span style="color:#b3b3b3;padding-left:3px">[' . Date::parse(Config::get('datimFormat'), $arrRow['ctime']) . ']</span></div>';
  }

  public function editFile($row, $href, $label, $title, $icon, $attributes)
  {
    if (!$this->User->isAdmin && !$this->User->hasAccess(1,'sec_dl_access'))
    {
      return '';
    }

    $objSecFile = \SecureDownloadsModel::findByPk($row['id']);
    $objFile = $objSecFile->getRelated('uuid');
    $title = sprintf($GLOBALS['TL_LANG']['tl_member_secureDownloads']['edit'][1],$objFile->name);

    $href .= '&amp;id='.$row['id'];

    return '<a href="'.$this->addToUrl($href).'" title="'.specialchars($title).'">'.Image::getHtml($icon, $label).'</a> ';
  }

  public function deleteFile($row, $href, $label, $title, $icon, $attributes)
  {
    if (!$this->User->isAdmin && !$this->User->hasAccess(1,'sec_dl_access'))
    {
      return '';
    }

    $objSecFile = \SecureDownloadsModel::findByPk($row['id']);
    $objFile = $objSecFile->getRelated('uuid');
    $attributes = ' onclick="if(!confirm(\'' . sprintf($GLOBALS['TL_LANG']['MSC']['deleteConfirmFile'],$objFile->name) . '\'))return false;Backend.getScrollOffset()"';
    $title = sprintf($GLOBALS['TL_LANG']['tl_member_secureDownloads']['delete'][1],$objFile->name);

    $href .= '&amp;id='.$row['id'];

    return '<a href="'.$this->addToUrl($href).'" title="'.specialchars($title).'"'.$attributes.'>'.Image::getHtml($icon, $label).'</a> ';
  }

  public function showFile($row, $href, $label, $title, $icon, $attributes)
  {
    if (Input::get('popup'))
    {
      return '';
    }
    else
    {
      $objSecFile = \SecureDownloadsModel::findByPk($row['id']);
      $objFile = $objSecFile->getRelated('uuid');
      $title = sprintf($GLOBALS['TL_LANG']['tl_member_secureDownloads']['show'][1],$objFile->name);

      if ($objFile !== null)
      {
        return '<a href="contao/popup.php?src=' . base64_encode($objFile->path) . '" title="'.specialchars($title, false, true).'"'.$attributes.' onclick="Backend.openModalIframe({\'width\':600,\'title\':\''.str_replace("'", "\\'", specialchars($objFile->name, false, true)).'\',\'url\':this.href,\'height\':300});return false">'.Image::getHtml($icon, $label).'</a> ';
      } else {
        return '';
      }
    }
  }

  public function deleteFileCallback(DataContainer $dc)
  {
    $objSecFile = \SecureDownloadsModel::findByPk($dc->id);
    $objFile = $objSecFile->getRelated('uuid');

    if ($objFile !== null) {
      $File = new \File($objFile->path,true);
      $File->delete();
    }
  }

  public function getFilename($varValue, DataContainer $dc)
  {
    $objSecFile = \SecureDownloadsModel::findByPk($dc->id);
    $objFile = $objSecFile->getRelated('uuid');

    if ($objFile !== null) {
      return $objFile->name;
    }

    return null;
  }

  /**
   * Check a file name and romanize it
   *
   * @param string                  $varValue
   * @param DataContainer|DC_Folder $dc
   *
   * @return mixed
   *
   * @throws Exception
   */
  public function checkFilename($varValue, DataContainer $dc)
  {
    $varValue = utf8_romanize($varValue);
    $varValue = str_replace('"', '', $varValue);

    if (strpos($varValue, '/') !== false || preg_match('/\.$/', $varValue))
    {
      throw new Exception($GLOBALS['TL_LANG']['ERR']['invalidName']);
    }

    // Check the length without the file extension
    if ($dc->activeRecord && $varValue != '')
    {
      $intMaxlength = $GLOBALS['TL_DCA'][$dc->table]['fields'][$dc->field]['eval']['maxlength'];

      if ($dc->activeRecord->type == 'file')
      {
        $intMaxlength -= (strlen($dc->activeRecord->extension) + 1);
      }

      if ($intMaxlength && utf8_strlen($varValue) > $intMaxlength)
      {
        throw new Exception(sprintf($GLOBALS['TL_LANG']['ERR']['maxlength'], $GLOBALS['TL_DCA'][$dc->table]['fields'][$dc->field]['label'][0], $intMaxlength));
      }
    }

    $objSecFile = \SecureDownloadsModel::findByPk($dc->id);
    $objFile = $objSecFile->getRelated('uuid');
    $File = new \File($objFile->path,true);

    if (!$File->exists())
    {
      throw new Exception(sprintf($GLOBALS['TL_LANG']['ERR']['invalidFile'],'1'.$varValue));
    }

    $strDirectory = dirname($objFile->path);
    if (!$File->renameTo($strDirectory.'/'.$varValue))
    {
      throw new Exception(sprintf($GLOBALS['TL_LANG']['ERR']['invalidFile'],'2'.$varValue));
    }

    if (($objFile = $File->getModel()) !== null) {
      $objSecFile = \SecureDownloadsModel::findByPk($dc->id);

      if ($objSecFile !== null){
        $objSecFile->uuid = $objFile->uuid;
        $objSecFile->save();
      }
    }

    return null;
  }
}
