<?php

declare(strict_types=1);

namespace vonRotenberg\MemberfilesBundle\Model;

use Contao\Model;
use Contao\Model\Collection;

/**
 * Reads and writes memberfiles configurations
 *
 * @property string|integer      $id
 * @property string|integer      $tstamp
 * @property string              $title
 * @property string              $regexp
 * @property string|boolean      $hasNotification
 *
 * @method static MemberfilesConfigModel|null findById($id, array $opt=array())
 * @method static MemberfilesConfigModel|null findByPk($id, array $opt=array())
 * @method static MemberfilesConfigModel|null findOneBy($col, $val, array $opt=array())
 * @method static MemberfilesConfigModel|null findOneByTstamp($val, array $opt=array())
 * @method static MemberfilesConfigModel|null findOneByTitle($val, array $opt=array())
 * @method static MemberfilesConfigModel|null findOneByRegexp($val, array $opt=array())
 * @method static MemberfilesConfigModel|null findOneByHasNotification($val, array $opt=array())
 *
 * @method static Collection|MemberfilesConfigModel[]|MemberfilesConfigModel|null findByTstamp($val, array $opt=array())
 * @method static Collection|MemberfilesConfigModel[]|MemberfilesConfigModel|null findByTitle($val, array $opt=array())
 * @method static Collection|MemberfilesConfigModel[]|MemberfilesConfigModel|null findByRegexp($val, array $opt=array())
 * @method static Collection|MemberfilesConfigModel[]|MemberfilesConfigModel|null findByHasNotification($val, array $opt=array())
 *
 * @method static integer countById($id, array $opt=array())
 * @method static integer countByTstamp($val, array $opt=array())
 * @method static integer countByTitle($val, array $opt=array())
 * @method static integer countByRegexp($val, array $opt=array())
 * @method static integer countByHasNotification($val, array $opt=array())
 */
class MemberfilesConfigModel extends Model
{
    /**
     * Table name
     * @var string
     */
    protected static $strTable = 'tl_memberfiles_config';
}
