<?php

/**
 * Memberfiles for Contao
 *
 * Copyright (c) 2017 Benjamin Roth
 *
 * @license commercial
 */

/**
 * Table tl_member_secureDownloads
 */

use Contao\DC_Table;

$GLOBALS['TL_DCA']['tl_member_secureDownloads'] = array
(

    // Config
    'config' => array
    (
        'dataContainer' => DC_Table::class,
        'ptable' => 'tl_member',
        'closed' => true,
        'doNotCopyRecords' => true,
        'sql' => array
        (
            'keys' => array
            (
                'id' => 'primary',
                'pid' => 'index'
            )
        )
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => 4,
            'fields' => array('ctime'),
            'headerFields' => array('firstname', 'lastname', 'username', 'memberno'),
            'disableGrouping' => false,
            'flag' => 6,
            'panelLayout' => 'filter;sort,search,limit',
        ),
        'global_operations' => array
        (),
        'operations' => array
        (
            'edit' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_member_secureDownloads']['edit'],
                'href' => 'act=edit',
                'icon' => 'edit.gif',
            ),
            'delete' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_member_secureDownloads']['delete'],
                'href' => 'act=delete',
                'icon' => 'delete.gif',
            ),
            'show' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_member_secureDownloads']['show'],
                'icon' => 'show.gif',
            ),
        )
    ),

    // Palettes
    'palettes' => array
    (
        'default' => '{sec_dl_legend},name'
    ),

    // Subpalettes
    'subpalettes' => array
    (),

    // Fields
    'fields' => array
    (
        'id' => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment"
        ),
        'pid' => array
        (
            'foreignKey' => 'tl_member.name',
            'sql' => "int(10) unsigned NOT NULL default '0'",
            'relation' => array('type' => 'belongsTo', 'load' => 'lazy')
        ),
        'uuid' => array
        (
            'foreignKey' => 'tl_files.name',
            'sql' => "binary(16) NULL",
            'relation' => array('type' => 'belongsTo', 'load' => 'lazy', 'field' => 'uuid')
        ),
        'tstamp' => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'"
        ),
        'ctime' => array
        (
            'exclude'               => true,
            'label' => &$GLOBALS['TL_LANG']['tl_member_secureDownloads']['ctime'],
            'sorting' => true,
            'flag' => 6,
            'sql' => "int(10) unsigned NOT NULL default '0'"
        ),
        'opened' => array
        (
            'exclude'               => true,
            'label' => &$GLOBALS['TL_LANG']['tl_member_secureDownloads']['opened'],
            'sql' => "int(10) unsigned NOT NULL default '0'"
        ),
        /*'name' => array
        (
            'exclude' => true,
            'label' => &$GLOBALS['TL_LANG']['tl_member_secureDownloads']['name'],
            'sorting' => true,
            'flag' => 1,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'maxlength' => 255, 'decodeEntities' => true, 'doNotSaveEmpty' => true),
            'sql'                     => "varchar(255) NOT NULL default ''"
        ),*/
        /*'path' => array
        (
          'sql'                     => "varchar(1022) NOT NULL default ''",
        ),*/
        'nc_sent' => array
        (
            'sql' => "char(1) NOT NULL default ''"
        ),
    )
);
