<?php

/**
 * Pagelist for Contao
 *
 * Copyright (c) 2015 Benjamin Roth
 *
 * @license LGPL-3.0+
 */

/**
 * Palettes
 */
$GLOBALS['TL_DCA']['tl_page']['palettes']['__selector__'][] = 'secureDownloadsEnabled';
$GLOBALS['TL_DCA']['tl_page']['palettes']['root'] = str_replace(';{publish_legend}', ';{sec_dl_legend},secureDownloadsEnabled;{publish_legend}',$GLOBALS['TL_DCA']['tl_page']['palettes']['root']);
$GLOBALS['TL_DCA']['tl_page']['subpalettes']['secureDownloadsEnabled'] = 'secureDownloadsSRC,secureDownloadsTarget,secureDownloadsRegExp,secureDownloadsFields,sd_nc_enable,sd_nc_notification';


/**
 * Fields
 */
$GLOBALS['TL_DCA']['tl_page']['fields']['secureDownloadsEnabled'] = array
(
  'label'                   => &$GLOBALS['TL_LANG']['tl_page']['secureDownloadsEnabled'],
  'exclude'                 => true,
  'inputType'               => 'checkbox',
  'eval'                    => array('submitOnChange'=>true),
  'sql'                     => "char(1) NOT NULL default ''"
);
$GLOBALS['TL_DCA']['tl_page']['fields']['secureDownloadsSRC'] = array
(
    'label'                   => &$GLOBALS['TL_LANG']['tl_page']['secureDownloadsSRC'],
    'exclude'                 => true,
    'inputType'               => 'fileTree',
    'eval'                    => array('mandatory'=>true,'fieldType'=>'radio', 'tl_class'=>'clr'),
    'sql'                     => 'binary(16) NULL'
);

$GLOBALS['TL_DCA']['tl_page']['fields']['secureDownloadsTarget'] = array
(
  'label'                   => &$GLOBALS['TL_LANG']['tl_page']['secureDownloadsTarget'],
  'exclude'                 => true,
  'inputType'               => 'fileTree',
  'eval'                    => array('mandatory'=>true,'fieldType'=>'radio', 'tl_class'=>'clr'),
  'sql'                     => 'binary(16) NULL'
);

$GLOBALS['TL_DCA']['tl_page']['fields']['secureDownloadsRegExp'] = array
(
  'label'                   => &$GLOBALS['TL_LANG']['tl_page']['secureDownloadsRegExp'],
  'exclude'                 => true,
  'inputType'               => 'text',
  'eval'                    => array('mandatory'=>true,'maxlength'=>64,'preserveTags'=>true,'decodeEntities'=>true),
  'sql'                     => 'varchar(64) NULL'
);

$GLOBALS['TL_DCA']['tl_page']['fields']['secureDownloadsFields'] = array
(
  'label'                   => &$GLOBALS['TL_LANG']['tl_page']['secureDownloadsFields'],
  'exclude'                 => true,
  'inputType'               => 'checkboxWizard',
  'options_callback'        => array('tl_page_eSM_secureDownloads','getMemberProperties'),
  'eval'                    => array('mandatory'=>true,'multiple'=>true),
  'sql'                     => 'varchar(255) NULL'
);

$GLOBALS['TL_DCA']['tl_page']['fields']['sd_nc_enable'] = array
(
  'label'                   => &$GLOBALS['TL_LANG']['tl_page']['sd_nc_enable'],
  'exclude'                 => true,
  'inputType'               => 'checkbox',
  'eval'                    => array('tl_class'=>'w50 m12','submitOnChange'=>true),
  'sql'                     => "char(1) NOT NULL default ''"
);

$GLOBALS['TL_DCA']['tl_page']['fields']['sd_nc_notification'] = array
(
  'label'                     => &$GLOBALS['TL_LANG']['tl_page']['sd_nc_enable'],
  'exclude'                   => true,
  'inputType'                 => 'select',
  'options_callback'          => array('tl_page_eSM_secureDownloads', 'getNotificationChoices'),
  'eval'                      => array('mandatory'=>true,'includeBlankOption'=>true, 'chosen'=>true, 'tl_class'=>'w50'),
  'sql'                       => "int(10) unsigned NOT NULL default '0'"
);

class tl_page_eSM_secureDownloads extends \Backend
{
  /**
   * Import the back end user object
   */
  public function __construct()
  {
    parent::__construct();
    $this->import('BackendUser', 'User');
  }

  /**
   * Return all fields of table tl_member
   *
   * @return array
   */
  public function getMemberProperties()
  {
    $return = array('id'=>'ID');

    System::loadLanguageFile('tl_member');
    $this->loadDataContainer('tl_member');

    foreach ($GLOBALS['TL_DCA']['tl_member']['fields'] as $k=>$v)
    {
      if (is_array($v['label']))
      {
        $return[$k] = $GLOBALS['TL_DCA']['tl_member']['fields'][$k]['label'][0];
      }
    }

    return $return;
  }

  /**
   * Get notification choices
   *
   * @return array
   */
  public function getNotificationChoices()
  {
    $arrChoices = array();
    $objNotifications = \Database::getInstance()->execute("SELECT id,title FROM tl_nc_notification WHERE type='secDownloads_submitted' ORDER BY title");

    while ($objNotifications->next()) {
      $arrChoices[$objNotifications->id] = $objNotifications->title;
    }

    return $arrChoices;
  }
}