<?php

/*
 * This file is part of memberfiles bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\MemberfilesBundle\Model;

use Contao\Model;
use Contao\Model\Collection;

/**
 * Reads and writes secure downloads for members
 *
 * @property string|integer      $id
 * @property string|integer      $tstamp
 * @property string              $title
 * @property string              $modal_title
 * @property string|integer      $delay
 * @property string|boolean      $show_once
 * @property string|integer      $start
 * @property string|integer      $stop
 *
 * @method static SecureDownloadsModel|null findById($id, array $opt=array())
 * @method static SecureDownloadsModel|null findByPk($id, array $opt=array())
 * @method static SecureDownloadsModel|null findOneBy($col, $val, array $opt=array())
 * @method static SecureDownloadsModel|null findOneByTstamp($val, array $opt=array())
 * @method static SecureDownloadsModel|null findOneByTitle($val, array $opt=array())
 * @method static SecureDownloadsModel|null findOneByModalTitle($val, array $opt=array())
 * @method static SecureDownloadsModel|null findOneByDelay($val, array $opt=array())
 * @method static SecureDownloadsModel|null findOneByShowOnce($val, array $opt=array())
 * @method static SecureDownloadsModel|null findOneByPublished($val, array $opt=array())
 * @method static SecureDownloadsModel|null findOneByStart($val, array $opt=array())
 * @method static SecureDownloadsModel|null findOneByStop($val, array $opt=array())
 *
 * @method static Collection|SecureDownloadsModel[]|SecureDownloadsModel|null findByTstamp($val, array $opt=array())
 * @method static Collection|SecureDownloadsModel[]|SecureDownloadsModel|null findByTitle($val, array $opt=array())
 * @method static Collection|SecureDownloadsModel[]|SecureDownloadsModel|null findByModalTitle($val, array $opt=array())
 * @method static Collection|SecureDownloadsModel[]|SecureDownloadsModel|null findByDelay($val, array $opt=array())
 * @method static Collection|SecureDownloadsModel[]|SecureDownloadsModel|null findByShowOnce($val, array $opt=array())
 * @method static Collection|SecureDownloadsModel[]|SecureDownloadsModel|null findByPublished($val, array $opt=array())
 * @method static Collection|SecureDownloadsModel[]|SecureDownloadsModel|null findByStart($val, array $opt=array())
 * @method static Collection|SecureDownloadsModel[]|SecureDownloadsModel|null findByStop($val, array $opt=array())
 * @method static Collection|SecureDownloadsModel[]|SecureDownloadsModel|null findMultipleByIds($val, array $opt=array())
 * @method static Collection|SecureDownloadsModel[]|SecureDownloadsModel|null findBy($col, $val, array $opt=array())
 * @method static Collection|SecureDownloadsModel[]|SecureDownloadsModel|null findAll(array $opt=array())
 *
 * @method static integer countById($id, array $opt=array())
 * @method static integer countByTstamp($val, array $opt=array())
 * @method static integer countByTitle($val, array $opt=array())
 * @method static integer countByModalTitle($val, array $opt=array())
 * @method static integer countByDelay($val, array $opt=array())
 * @method static integer countByShowOnce($val, array $opt=array())
 * @method static integer countByPublished($val, array $opt=array())
 * @method static integer countByStart($val, array $opt=array())
 * @method static integer countByStop($val, array $opt=array())
 */
class SecureDownloadsModel extends Model
{
	/**
	 * Table name
	 * @var string
	 */
	protected static $strTable = 'tl_member_secureDownloads';


}

class_alias(SecureDownloadsModel::class, 'SecureDownloadsModel');
