<?php

/**
 * Memberfiles for Contao
 *
 * Copyright (c) 2017 Benjamin Roth
 *
 * @license commercial
 */

use Contao\DataContainer;
use Contao\DC_Table;

$GLOBALS['TL_DCA']['tl_memberfiles_config'] = [
    'config'   => [
        'dataContainer'    => DC_Table::class,
        'enableVersioning' => true,
        'sql'              => [
            'keys' => [
                'id' => 'primary'
            ]
        ]
    ],
    'list'     => [
        'sorting'           => [
            'mode'        => DataContainer::MODE_SORTED,
            'fields'      => ['title'],
            'flag'        => DataContainer::SORT_INITIAL_LETTER_ASC,
            'panelLayout' => 'filter;search,limit'
        ],
        'label'             => [
            'fields' => ['title'],
            'format' => '%s'
        ],
        'global_operations' => [
            'all' => [
                'href'       => 'act=select',
                'class'      => 'header_edit_all',
                'attributes' => 'onclick="Backend.getScrollOffset()" accesskey="e"'
            ]
        ],
        'operations'        => [
            'edit'   => [
                'href' => 'act=edit',
                'icon' => 'edit.svg'
            ],
            'copy' => [
                'href' => 'act=copy',
                'icon' => 'copy.svg'
            ],
            'delete' => [
                'href'       => 'act=delete',
                'icon'       => 'delete.svg',
                'attributes' => 'onclick="if(!confirm(\'' . ($GLOBALS['TL_LANG']['MSC']['deleteConfirm'] ?? null) . '\'))return false;Backend.getScrollOffset()"'
            ],
            'toggle' => [
                'href'       => 'act=toggle&amp;field=enabled',
                'icon'       => 'visible.svg',
                'attributes' => 'onclick="Backend.getScrollOffset();return AjaxRequest.toggleVisibility(this,%s)"'
            ],
            'show'   => [
                'href' => 'act=show',
                'icon' => 'show.svg'
            ]
        ]
    ],
    'palettes' => [
        '__selector__' => ['hasNotification'],
        'default' => '{title_legend},title;{config_legend},source,target,regexp,fields,hasNotification;{enabled_legend},enabled',
    ],
    'subpalettes' => [
        'hasNotification' => 'notification',
    ],
    'fields'   => [
        'id'     => [
            'sql'       => ['type' => 'integer', 'unsigned' => true, 'autoincrement' => true]
        ],
        'tstamp' => [
            'sql'       => ['type' => 'integer', 'unsigned' => true, 'default' => 0]
        ],
        'title'  => [
            'inputType' => 'text',
            'exclude'   => true,
            'search'    => true,
            'eval'      => ['mandatory' => true, 'maxlength' => 255, 'tl_class' => 'w50'],
            'sql'       => ['type' => 'string', 'length' => 255, 'default' => '']
        ],
        'source'  => [
            'exclude'   => true,
            'inputType' => 'fileTree',
            'eval'      => ['mandatory' => true, 'fieldType' => 'radio', 'tl_class' => 'clr'],
            'sql'       => ['type' => 'binary', 'length' => 16, 'fixed' => true, 'notnull'=> false]
        ],
        'target'  => [
            'exclude'   => true,
            'inputType' => 'fileTree',
            'eval'      => ['mandatory' => true, 'fieldType' => 'radio', 'tl_class' => 'clr'],
            'sql'       => ['type' => 'binary', 'length' => 16, 'fixed' => true, 'notnull'=> false]
        ],
        'regexp'  => [
            'exclude'   => true,
            'inputType' => 'text',
            'eval'      => ['mandatory' => true, 'tl_class' => 'w50', 'maxlength' => 64, 'preserveTags' => true, 'decodeEntities' => true, 'placeholder' => &$GLOBALS['TL_LANG']['tl_memberfiles_config']['regexp']['placeholder']],
            'sql'       => ['type' => 'string', 'length' => 64, 'default' => '']
        ],
        'fields'  => [
            'exclude'   => true,
            'inputType' => 'checkboxWizard',
            'eval'      => ['mandatory' => true, 'multiple' => true, 'tl_class' => 'clr'],
            'sql'       => ['type' => 'blob', 'notnull' => false]
        ],
        'hasNotification'  => [
            'exclude'   => true,
            'inputType' => 'checkbox',
            'eval'      => ['submitOnChange' => true, 'tl_class' => 'w50'],
            'sql'       => ['type' => 'string', 'length' => 1, 'fixed' => true, 'default' => '']
        ],
        'notification'  => [
            'exclude'   => true,
            'inputType' => 'select',
            'eval'      => ['mandatory' => true, 'includeBlankOption' => true, 'chosen' => true, 'tl_class' => 'w50'],
            'sql'       => ['type' => 'integer', 'unsigned' => true, 'default' => 0]
        ],
        'enabled' => [
            'exclude'   => true,
            'toggle'    => true,
            'inputType' => 'checkbox',
            'eval'      => ['tl_class' => 'w50'],
            'sql'       => ['type' => 'string', 'length' => 1, 'fixed' => true, 'default' => '']
        ],

    ]
];
