<?php

/**
 * Memberfiles for Contao
 *
 * Copyright (c) 2017 Benjamin Roth
 *
 * @license commercial
 */

use Contao\CoreBundle\DataContainer\PaletteManipulator;
use vonRotenberg\MemberfilesBundle\Model\SecureDownloadsModel;

PaletteManipulator::create()
    ->addField('memberno', 'personal_legend', PaletteManipulator::POSITION_APPEND)
    ->applyToPalette('default', 'tl_member');

/**
 * Fields
 */
$GLOBALS['TL_DCA']['tl_member']['fields']['memberno'] = [
    'exclude'   => true,
    'inputType' => 'text',
    'search'    => true,
    'eval'      => [
        'maxlength' => 32,
        'tl_class'  => 'w50'
    ],
    'sql'       => ['type' => 'string', 'length' => 32, 'default' => '']
];

/**
 * Config
 */
$GLOBALS['TL_DCA']['tl_member']['config']['ctable'][] = 'tl_member_secureDownloads';

/**
 * Labels
 */
\Contao\ArrayUtil::arrayInsert($GLOBALS['TL_DCA']['tl_member']['list']['label']['fields'],array_search('dateAdded',$GLOBALS['TL_DCA']['tl_member']['list']['label']['fields']),['memberno']);

/**
 * Operations
 */
$GLOBALS['TL_DCA']['tl_member']['list']['operations']['secureDownloads'] = array
(
    'label' => &$GLOBALS['TL_LANG']['tl_member']['secureDownloads'],
    'href'  => 'table=' . SecureDownloadsModel::getTable(),
    'icon'  => 'bundles/vonrotenbergmemberfiles/images/folder-secure.svg',

);
