# Contao Memberfiles Bundle

A Contao bundle for managing secure member-specific file downloads with automatic file assignment and email notifications.

## Features

- **Automatic File Import**: Files are automatically imported from source folders and assigned to members based on filename patterns
- **Secure Downloads**: Files are stored in member-specific directories and accessible only to the respective member
- **Email Notifications**: Members receive email notifications when new files are added
- **Flexible Configuration**: Multiple configurations with different source folders and filename patterns
- **Backend Integration**: Full Contao backend integration for managing member files
- **Frontend Module**: Content element for displaying member files in the frontend

## Requirements

- PHP 7.4 or 8.0+
- Contao 4.13+
- Symfony 5.4+
- Notification Center 1.7+

## Installation

Install the bundle via Composer:

```bash
composer require vonrotenberg/contao-memberfiles-bundle
```

## Configuration

1. Create a configuration in the backend (Memberfiles Configuration)
2. Define:
   - Source folder (where files are uploaded)
   - Target folder (where files are stored)
   - Regular expression to extract member identifier from filename
   - Member fields to match against
   - Optional: Email notification settings

## File Naming Convention

Files must follow a naming pattern that includes member identifiers. For example:
- `invoice_12345_document.pdf` (where 12345 is the member ID)
- `report_smith_john.pdf` (where smith/john match member fields)

The regular expression in the configuration extracts these identifiers.

## Cron Jobs

The bundle includes two cron jobs:
- **Import Job** (runs every minute): Imports new files from source folders
- **Notification Job** (runs every 10 minutes): Sends email notifications for new files

## Testing

Run code quality checks before releasing:

```bash
composer ecs
composer phpstan
composer unit-tests
```

Or run all checks at once:

```bash
composer all
```

## License

This bundle is proprietary software. All rights reserved.

(c) vonRotenberg
