<?php

/**
 * SecureDownloads for Contao
 *
 * Copyright (c) 2017 Benjamin Roth
 *
 * @license commercial
 */


/**
 * Config
 */
$GLOBALS['TL_DCA']['tl_member']['config']['ctable'][] = 'tl_member_secureDownloads';

/**
 * Operations
 */
$GLOBALS['TL_DCA']['tl_member']['list']['operations']['secureDownloads'] = array
(
  'label'               => &$GLOBALS['TL_LANG']['tl_member']['secureDownloads'],
  'href'                => 'table='.\eSM_secureDownloads\SecureDownloadsModel::getTable(),
  'icon'                => 'system/modules/eSM_secureDownloads/assets/images/sec_files.png',
  'button_callback'     => array('tl_member_eSM_secureDownloads', 'showDownloads')

);


class tl_member_eSM_secureDownloads extends \Backend
{
  /**
   * Import the back end user object
   */
  public function __construct()
  {
    parent::__construct();
    $this->import('BackendUser', 'User');
  }


  /**
   * Generate a "showDownloads" button and return it as string
   *
   * @param array  $row
   * @param string $href
   * @param string $label
   * @param string $title
   * @param string $icon
   *
   * @return string
   */
  public function showDownloads($row, $href, $label, $title, $icon)
  {
    if (!$this->User->isAdmin && !$this->User->hasAccess(1,'sec_dl_access'))
    {
      return '';
    }

    $href .= '&amp;id='.$row['id'];

    return '<a href="'.$this->addToUrl($href).'" title="'.specialchars($title).'">'.Image::getHtml($icon, $label).'</a> ';
  }

}