<?php

/*
 * This file is part of Contao.
 *
 * (c) Leo Feyer
 *
 * @license LGPL-3.0-or-later
 */

use vonRotenberg\MemberfilesBundle\Model\MemberfilesConfigModel;
use vonRotenberg\MemberfilesBundle\Model\SecureDownloadsModel;

/**
 * Backend modules
 */
$GLOBALS['BE_MOD']['system']['memberfiles'] = [
    'tables' => ['tl_memberfiles_config']
];
$GLOBALS['BE_MOD']['accounts']['member']['tables'][] = 'tl_member_secureDownloads';

/**
 * Notification types
 */
$GLOBALS['NOTIFICATION_CENTER']['NOTIFICATION_TYPE']['contao']['secDownloads_submitted'] = array
(
    'recipients'    => array
    (
        'member_email' // The email address of the recipient
    ),
    'email_text'    => array
    (
        'member_firstname', // The firstname of the recipient
        'member_lastname', // The lastname of the recipient
        'downloads' // The names of all new files
    ),
    'email_html'    => array
    (
        'member_firstname', // The firstname of the recipient
        'member_lastname', // The lastname of the recipient
        'downloads_html', // The names of all new files
    )
);

/**
 * Permissions
 */

$GLOBALS['TL_PERMISSIONS'][] = 'sec_dl_access';

/**
 * Models
 */

$GLOBALS['TL_MODELS']['tl_member_secureDownloads'] = SecureDownloadsModel::class;
$GLOBALS['TL_MODELS']['tl_memberfiles_config'] = MemberfilesConfigModel::class;
