<?php

/**
 * Pagelist for Contao
 *
 * Copyright (c) 2015 Benjamin Roth
 *
 * @license LGPL-3.0+
 */

use Contao\CoreBundle\DataContainer\PaletteManipulator;

/**
 * Palettes
 */

PaletteManipulator::create()
    ->addLegend('sec_dl_legend', 'publish_legend', PaletteManipulator::POSITION_BEFORE)
    ->addField('secureDownloadsEnabled', 'sec_dl_legend', PaletteManipulator::POSITION_APPEND)
    ->applyToPalette('root', 'tl_page')
    ->applyToPalette('rootfallback', 'tl_page');

$GLOBALS['TL_DCA']['tl_page']['palettes']['__selector__'][] = 'secureDownloadsEnabled';
$GLOBALS['TL_DCA']['tl_page']['palettes']['__selector__'][] = 'sd_nc_enable';
$GLOBALS['TL_DCA']['tl_page']['subpalettes']['secureDownloadsEnabled'] = 'secureDownloadsSRC,secureDownloadsTarget,secureDownloadsRegExp,secureDownloadsFields,sd_nc_enable';
$GLOBALS['TL_DCA']['tl_page']['subpalettes']['sd_nc_enable'] = 'sd_nc_notification';


/**
 * Fields
 */
$GLOBALS['TL_DCA']['tl_page']['fields']['secureDownloadsEnabled'] = array
(
    'exclude' => true,
    'inputType' => 'checkbox',
    'eval' => array('submitOnChange' => true),
    'sql' => "char(1) NOT NULL default ''"
);
$GLOBALS['TL_DCA']['tl_page']['fields']['secureDownloadsSRC'] = array
(
    'exclude' => true,
    'inputType' => 'fileTree',
    'eval' => array('mandatory' => true, 'fieldType' => 'radio', 'tl_class' => 'clr'),
    'sql' => 'binary(16) NULL'
);

$GLOBALS['TL_DCA']['tl_page']['fields']['secureDownloadsTarget'] = array
(
    'exclude' => true,
    'inputType' => 'fileTree',
    'eval' => array('mandatory' => true, 'fieldType' => 'radio', 'tl_class' => 'clr'),
    'sql' => 'binary(16) NULL'
);

$GLOBALS['TL_DCA']['tl_page']['fields']['secureDownloadsRegExp'] = array
(
    'exclude' => true,
    'inputType' => 'text',
    'eval' => array('mandatory' => true, 'maxlength' => 64, 'preserveTags' => true, 'decodeEntities' => true),
    'sql' => 'varchar(64) NULL'
);

$GLOBALS['TL_DCA']['tl_page']['fields']['secureDownloadsFields'] = array
(
    'exclude' => true,
    'inputType' => 'checkboxWizard',
    'eval' => array('mandatory' => true, 'multiple' => true),
    'sql' => 'varchar(255) NULL'
);

$GLOBALS['TL_DCA']['tl_page']['fields']['sd_nc_enable'] = array
(
    'exclude' => true,
    'inputType' => 'checkbox',
    'eval' => array('tl_class' => 'w50 m12', 'submitOnChange' => true),
    'sql' => "char(1) NOT NULL default ''"
);

$GLOBALS['TL_DCA']['tl_page']['fields']['sd_nc_notification'] = array
(
    'exclude' => true,
    'inputType' => 'select',
    'eval' => array('mandatory' => true, 'includeBlankOption' => true, 'chosen' => true, 'tl_class' => 'w50'),
    'sql' => "int(10) unsigned NOT NULL default '0'"
);
