<?php

/**
 * Memberfiles for Contao
 *
 * Copyright (c) 2017 Benjamin Roth
 *
 * @license commercial
 */

use Contao\CoreBundle\DataContainer\PaletteManipulator;

/**
 * Extend a tl_user_group palette
 */
PaletteManipulator::create()
    ->addLegend('sec_dl_legend','alexf_legend',PaletteManipulator::POSITION_BEFORE)
    ->addField('sec_dl_access','sec_dl_legend',PaletteManipulator::POSITION_APPEND)
    ->applyToPalette('default', 'tl_user_group');

/**
 * Add fields to tl_user_group
 */
$GLOBALS['TL_DCA']['tl_user_group']['fields']['sec_dl_access'] = array
(
    'label'                 => &$GLOBALS['TL_LANG']['tl_user_group']['sec_dl_access'],
    'exclude'               => true,
    'filter'                => true,
    'options'               => array('edit'),
    'reference'             => &$GLOBALS['TL_LANG']['MSC'],
    'inputType'             => 'checkbox',
    'sql'                   => "blob NULL"

);
