<?php

declare(strict_types=1);

/*
 * This file is part of memberfiles bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\MemberfilesBundle\EventListener\DataContainer;

use Contao\BackendUser;
use Contao\Controller;
use Contao\CoreBundle\ServiceAnnotation\Callback;
use Contao\DataContainer;
use Contao\System;

/**
 * Listener for page data container operations (legacy support)
 */
class PageListener {

    protected BackendUser $User;

    public function __construct()
    {
        $this->User = BackendUser::getInstance();
    }

    /**
     * @Callback(table="tl_page", target="fields.secureDownloadsFields.options")
     */
    public function onSecureDownloadsFieldsOptionsCallback(?DataContainer $dc)
    {
        $return = array('id'=>'ID');

        System::loadLanguageFile('tl_member');
        Controller::loadDataContainer('tl_member');

        foreach ($GLOBALS['TL_DCA']['tl_member']['fields'] as $k=>$v)
        {
            if (is_array($v['label']))
            {
                $return[$k] = $GLOBALS['TL_DCA']['tl_member']['fields'][$k]['label'][0];
            }
        }

        return $return;
    }

    /**
     * @Callback(table="tl_page", target="fields.sd_nc_notification.options")
     */
    public function onSdNcNotificationOptionsCallback(?DataContainer $dc)
    {
        $arrChoices = array();
        $objNotifications = \Database::getInstance()->execute("SELECT id,title FROM tl_nc_notification WHERE type='secDownloads_submitted' ORDER BY title");

        while ($objNotifications->next()) {
            $arrChoices[$objNotifications->id] = $objNotifications->title;
        }

        return $arrChoices;
    }

}
