<?php

declare(strict_types=1);

/*
 * This file is part of memberfiles bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\MemberfilesBundle\EventListener\DataContainer;

use Contao\Backend;
use Contao\BackendUser;
use Contao\CoreBundle\ServiceAnnotation\Callback;
use Contao\DataContainer;
use Contao\File;
use Contao\Image;
use Contao\Input;
use Contao\StringUtil;
use Contao\System;
use Contao\Date;
use Contao\Config;
use vonRotenberg\MemberfilesBundle\Model\SecureDownloadsModel;

class MemberListener {

    /**
     * @var BackendUser
     */
    protected $User;

    public function __construct()
    {
        $this->User = BackendUser::getInstance();
    }

    /**
     * @Callback(table="tl_member", target="list.operations.secureDownloads.button")
     */
    public function onListSecureDownloadsOperationCallback(array $row, ?string $href, string $label, string $title, ?string $icon, string $attributes, string $table, array $rootRecordIds, ?array $childRecordIds, bool $circularReference, ?string $previous, ?string $next, DataContainer $dc)
    {
        if (!$this->User->isAdmin && !$this->User->hasAccess('tl_member_secureDownloads::ctime','alexf'))
        {
            return '';
        }

        $href .= '&amp;id='.$row['id'];

        return '<a href="'.Backend::addToUrl($href).'" title="'.StringUtil::specialchars($title).'">'.Image::getHtml($icon, $label).'</a> ';
    }

}
