<p align="center"><img src="/assets/markdown/logo.svg" width="200" alt="Contao Member Extension Bundle"></p>
<h1 align="center">Contao Member Extension Bundle</h1>
<p align="center"><i>Adds a listing of members with detail pages and extends them with an avatar that can be uploaded and deleted</i></p>
<p align="center">
    <a href="https://github.com/oveleon/contao-member-extension-bundle"><img src="https://img.shields.io/github/license/oveleon/contao-member-extension-bundle?color=ef9838"/></a>
    <a href="https://www.oveleon.de"><img src="https://img.shields.io/badge/oveleon-maintained-ef9838?logo=data:image/png;base64,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" alt="Oveleon"></a>
    <a href="https://packagist.org/packages/oveleon/contao-member-extension-bundle"><img src="https://img.shields.io/packagist/dt/oveleon/contao-member-extension-bundle?color=59a192"/></a>
    <a href="https://packagist.org/packages/oveleon/contao-member-extension-bundle"><img src="https://img.shields.io/packagist/dependency-v/oveleon/contao-member-extension-bundle/php?color=59a192"></a>
<a href="https://github.com/sponsors/oveleon"><img src="https://img.shields.io/github/sponsors/oveleon?label=Sponsor&logo=GitHub&color=%23fe8e86"/></a>
</p>
<br/>

---

> Working with **Contao 4.13** and **Contao ^5.3** (PHP ^8.1)

---

The Member extension bunde adds the possibility to display members and their details in lists using frontend modules.
The member options are extended with an avatar that can be changed and uploaded in the member edit module and
registration module. Additionally, you can display members with their details in a reader page.

+ [Features](#features)
+ [Installation](#installation)
    + [Composer](#via-composer)
    + [Contao Manager](#via-contao-manager)
+ [Initial Setup](#initial-setup)
+ [Insert tags](#insert-tags)
    + [Avatar insert tags](#avatar-insert-tags)
+ [Front end modules](#front-end-modules)
    + [Memberlist](#memberlist)
    + [Memberreader](#memberreader)
    + [Avatar / Profile picture](#avatar--profile-picture)
    + [Delete avatar](#delete-avatar)
+ [Advanced](#advanced)
    + [Filter](#filter)
    + [Hooks](#hooks)
+ [Support](#support)
+ [Sponsoring](#sponsoring)

## Features

- Compatible with Contao 4.13 (PHP ^8.0)
- Extends members with avatars
- Paginated member lists
- Member detail pages
- Insert tags for member avatars
- Sortable data-tables (funded by @netzarbeiter)
  - requires jQuery to work (https://datatables.net/)

---

## Installation

#### Via composer

```
composer require oveleon/contao-member-extension-bundle
```

#### Via contao-manager

```
Search for contao member extension bundle and add it to your extensions.
```

After installing the contao-member-extension-bundle, you need to run a **contao install**.

---

## Initial setup

This bundle extends contao with the possibiity to extend members with an avatar and displaying members in a list with
detail pages.

1. Go into members and set up a default avatar in the newly added settings

   ![Admin View: Member overview](https://www.oveleon.de/share/github-assets/contao-member-extension-bundle/default_avatar.jpg)
   ![Admin View: Member settings](https://www.oveleon.de/share/github-assets/contao-member-extension-bundle/default_avatar_setup.jpg)

2. To display your members, you need to set up a memberlist
    1. Create the front end module *memberlist*
    2. Choose the member groups and the member fields that should be displayed
    3. Optionally you can set up a redirect page to your memberreader
    4. Embed the module in a page

   ![Admin View: Memberlist](https://www.oveleon.de/share/github-assets/contao-member-extension-bundle/module_memberlist.jpg)

3. Displaying the avatar
    1. Create the front end module *Avatar / profile picture*
    2. Optionally you can set an image size
    3. Embed the module in a page

   ![Admin View: MemberAvatar](https://www.oveleon.de/share/github-assets/contao-member-extension-bundle/module_memberavatar.jpg)

4. Module to delete an avatar
    1. Create the front end module *Delete Avatar*
    2. Embed the module in a page
    3. The module only appears if a frontend user is logged in
    4. You can check the "profile picture option" within registration to enable members to upload a profile picture
       within
       registration

   ![Admin View: MemberDeleteAvatar](https://www.oveleon.de/share/github-assets/contao-member-extension-bundle/module_memberdeleteavatar.jpg)

5. Member reader page
    1. Create the front end module *memberreader*
    2. Choose the member groups and the member fields that are allowed

---

## Insert tags

Member avatars can be shown using following *insert-tags*

> For more information on *Insert tags*, please visit the official <a href="https://docs.contao.org/manual/en/article-management/insert-tags/" title="Insert tags :: Contao Manual" target="_blank">Contao documentation</a>.

**Example**

```
{{avatar::member::current}}
{{avatar::member::current::200x200xproportional}}
{{avatar::member::4}}
{{avatar::member::4::300x300xcrop}}

// Output file url
{{avatar_url::member::current}}
{{avatar_url::member:4}}
```

The allowed image size parameters are:
"<strong>width</strong> x <strong>height</strong> x <strong>mode</strong>"

Size mode (See: [Size Array](https://docs.contao.org/dev/framework/image-processing/image-sizes/#size-array))

- crop
- box
- proportional _(Contao 4.13 only)_

The standard mode vor avatar insert tags is *crop*

### Avatar insert tags

<table>
  <tr>
    <th colspan="2"><strong>Member extension avatar</strong></th>
  </tr>
  <tr>
    <td><strong>Insert tag</strong></td>
    <td><strong>Description</strong></td>
  </tr>
  <tr>
    <td>{{avatar::member::current}}</td>
    <td>Displays the avatar of the logged in member</td>
  </tr>
  <tr>
    <td>{{avatar::member::current::200x300}}</td>
    <td>Displays the avatar of the logged in member with a width of 200 and a height of 300</td>
  </tr>
  <tr>
    <td>{{avatar::member::current::300x400xbox}}</td>
    <td>Displays the avatar of the logged in member with a width of 300, a height of 400 and the mode: box</td>
  </tr>
  <tr>
    <td>{{avatar::member::123}}</td>
    <td>Displays the avatar of member id 123</td>
  </tr>
  <tr>
    <td>{{avatar::member::123::200x300}}</td>
    <td>Displays the avatar of member id 123 with a width of 200 and a height of 300</td>
  </tr>
  <tr>
    <td>{{avatar::member::123::300x400xbox}}</td>
    <td>Displays the avatar of member id 123 with a width of 300, a height of 400 and the mode: box</td>
  </tr>
</table>

---

## Front end modules

### Memberlist

Displays activated members in a list.

### Memberreader

Displays a detail page of a member.

### Avatar / Profile picture

Displays an avatar of a member. If no avatar has been uploaded, the default avatar (or the fallback avatar from the
bundle) will be shown.

### Delete Avatar

A module that can be embedded into a page that adds the possibility to delete the avatar of a member.

---

## Advanced

The member extension provides additional options that can be used with programmatic knowledge.

### Filter

Allows filtering the member list in the frontend if the following conditions are met:

- 'Activate filters' is set to true within the member list module
- there exists fields within `tl_member` of inputType `checkbox` and evaluation `feFilterable` set to true

### Hooks

#### getMembers

Allows modifying the columns and options for the database query.

```php
// src/EventListener/onGetMembersListener.php
namespace App\EventListener;

use Contao\CoreBundle\DependencyInjection\Attribute\AsHook;
use Oveleon\ContaoMemberExtensionBundle\Controller\FrontendModule\MemberListController;

#[AsHook('getMembers')]
class onGetMembersListener
{
    public function __invoke(array &$columns, array &$options, MemberListController &$context): void
    {
        // Do something...
    }
}
```

#### parseMemberReader

Allows modifying the member detail page

```php
// src/EventListener/onParseMemberReaderListener.php
namespace App\EventListener;

use Contao\CoreBundle\DependencyInjection\Attribute\AsHook;
use Contao\MemberModel;
use Contao\Model;
use Contao\ModuleModel;
use Contao\Template;
use Oveleon\ContaoMemberExtensionBundle\Controller\FrontendModule\MemberReaderController;

#[AsHook('parseMemberReader')]
class onParseMemberReaderListener
{
    public function __invoke(MemberModel|Model &$member, Template &$template, ModuleModel &$model, MemberReaderController &$context): void
    {
        // Do something...
    }
}
```

#### parseMemberTemplate

Allows modifying the member details

```php
// src/EventListener/onParseMemberTemplateListener.php
namespace App\EventListener;

use Contao\CoreBundle\DependencyInjection\Attribute\AsHook;
use Contao\FrontendTemplate;
use Contao\MemberModel;
use Contao\Model;
use Contao\ModuleModel;
use Oveleon\ContaoMemberExtensionBundle\Controller\FrontendModule\MemberExtensionController;

#[AsHook('parseMemberTemplate')]
class onParseMemberTemplateListener
{
    public function __invoke(MemberModel|Model &$member, array &$fields, FrontendTemplate &$template, ModuleModel &$model, MemberExtensionController &$context): void
    {
        // Do something...
    }
}
```

---

## Support

> We **only provide support** for **bugs, and feature requests**; please only post issues about these two topics.
>
> If you need help implementing Contao Member Extension Bundle or you are just starting out
> with Contao/CSS or HTML, please contact us on our [website](https://www.oveleon.de/kontakt.html#kontaktformular),
> visit the [Contao Community](https://community.contao.org/)
> or the [Contao Slack](https://join.slack.com/t/contao/shared_invite/enQtNjUzMjY4MDU0ODM3LWVjYWMzODVkZjM5NjdlNDRiZjk2OTI3OWVkMmQ1YjA0MTQ3YTljMjFjODkwYTllN2NkMDcxMThiNzMzZjZlOGU),
> you will be able to find more help there.
>
> This will help us to keep the issues related to this plugin and solve them faster.

---

## Sponsoring

If you think this plugin is useful, please consider [sponsoring us](https://github.com/sponsors/oveleon) to help
contribute to our time invested and to further development of this and other open source projects.

Your contributions, whether through `coding`, `testing`, `providing feedback`, or even
a [donation](https://github.com/sponsors/oveleon), help ensure that we can continue offering free open source software.
Join us in making a difference, and thank you for your support! - [Oveleon](https://www.oveleon.de).

[![](https://img.shields.io/static/v1?label=Sponsor&message=%E2%9D%A4&logo=GitHub&color=%23fe8e86)](https://github.com/sponsors/oveleon)
