<?php

/**
 * eSales Media Formilicious for Contao Open Source CMS
 *
 * Copyright (C) 2013-2014 eSalesMedia
 *
 * @package    eSM_formilicious
 * @link       http://www.esales-media.de
 * @license    http://www.gnu.org/licenses/lgpl-3.0.html LGPL
 *
 * @author     Benjamin Roth <benjamin@esales-media.de>
 */


/**
 * Add fields to tl_module
 */
$GLOBALS['TL_DCA']['tl_module']['fields']['editable'] = array
(
  'exclude'               => true,
  'inputType'             => 'multiColumnWizard',
  'eval'                  => array
  (
    'tl_class'          =>'clr',
    'columnsCallback'   => array('formilicious_tl_module', 'onCoAddressFieldsColumnsCallback'),
    'buttons'           => array('copy'=>false, 'delete'=>false,'new'=>false),
    'dragAndDrop'       => true,
  ),
  'sql'                   => 'blob NULL',
  'load_callback'           => array
  (
    array('formilicious_tl_module','onLoadCoAddressFields')
  ),
  'save_callback'           => array
  (
    array('formilicious_tl_module','onSaveCoAddressFields')
  )
);

class formilicious_tl_module extends \Backend
{
  /**
   * @return array
   */
  public function getMandatoryMemberFields() : array
  {
    \Controller::loadDataContainer('tl_member');
    $arrFields = array();
    $arrDCA    = &$GLOBALS['TL_DCA']['tl_member']['fields'];
    foreach ($arrDCA as $field => $config) {
      $mandatory = $config['eval']['mandatory'];
      if ($mandatory) {
        $arrFields[] = $field;
      }
    }
    return $arrFields;
  }

  /**
   * For each call, return the name of the next attribute in the wizard (for input_field_callback)
   *
   * @param \Widget|object $objWidget
   *
   * @return string
   */
  public function onFieldnameInputFieldCallback($objWidget)
  {
    \System::loadLanguageFile('tl_member');
    \Controller::loadDataContainer('tl_member');

    static $arrValues;
    static $strWidget;
    static $i = 0;
    if ($objWidget->name !== $strWidget) {
      $strWidget = $objWidget->name;
      $arrValues = $objWidget->value;
      $i         = 0;
    }
    $arrField = array_shift($arrValues);
    $strName  = $arrField['name'];

    return sprintf(
      '<input type="hidden" name="%s[%s][name]" id="ctrl_%s_row%s_name" value="%s"><div style="width:150px">%s' . ($GLOBALS['TL_DCA']['tl_member']['fields'][$strName]['eval']['mandatory'] ? '<span class="mandatory">*</span>' : '') . ' <span style="color:#b3b3b3; padding-left:3px;">[%s]</span></div>',
      $objWidget->name,
      $i,
      $objWidget->name,
      $i++,
      $strName,
      ($GLOBALS['TL_DCA']['tl_member']['fields'][$strName]['label'][0] ? : ($GLOBALS['TL_LANG']['tl_member'][$strName][0] ? : $strName)),
      $strName
    );
  }

  /**
   * Return list of MultiColumnWizard columns
   *
   * @param MultiColumnWizard|object $objWidget
   *
   * @return array
   */
  public function onCoAddressFieldsColumnsCallback(\MultiColumnWizard $objWidget)
  {
    \Controller::loadDataContainer('tl_member');
    $arrValues   = $objWidget->value;

    if (!empty($arrValues) && \is_array($arrValues)) {
      $arrMandatory = $this->getMandatoryMemberFields();

      foreach ($arrValues as $i => $field) {
        if (\in_array($field['name'], $arrMandatory, true)) {
          $objWidget->addDataToFieldAtIndex($i, 'enabled', array('value'=>1,'eval' => array('disabled' => true)));
        }
      }
    }

    return array
    (
      'enabled'   => array
      (
        'inputType' => 'checkbox',
        'eval'      => array('hideHead' => true),
      ),
      'name'      => array
      (
        'input_field_callback' => array('formilicious_tl_module', 'onFieldnameInputFieldCallback'),
        'eval'                 => array('hideHead' => true, 'tl_class' => 'mcwUpdateFields'),
      ),
      'feGroup' => array
      (
        'label'     => &$GLOBALS['TL_LANG']['tl_module']['editable_cols']['feGroup'],
        'inputType' => 'select',
        'options'   => array('personal', 'address', 'contact', 'login'),
        'eval'      => array('style' => 'width:100px', 'includeBlankOption' => true, 'blankOptionLabel' => &$GLOBALS['TL_LANG']['MSC']['default']),
      ),
      'mandatory' => array
      (
        'label'     => &$GLOBALS['TL_LANG']['tl_module']['editable_cols']['mandatory'],
        'inputType' => 'select',
        'options'   => array('yes', 'no'),
        'reference' => &$GLOBALS['TL_LANG']['MSC'],
        'eval'      => array('style' => 'width:100px', 'includeBlankOption' => true, 'blankOptionLabel' => &$GLOBALS['TL_LANG']['MSC']['default']),
      ),
      'eSM_fl_class'  => array
      (
        'label'     => &$GLOBALS['TL_LANG']['tl_module']['editable_cols']['eSM_fl_class'],
        'inputType' => 'text',
        'eval'      => array('style' => 'width:80px'),
      ),
      'eSM_fl_width'  => array
      (
        'label'     => &$GLOBALS['TL_LANG']['tl_module']['editable_cols']['eSM_fl_width'],
        'inputType' => 'select',
        'default'   => 100,
        'options'   => array(10, 11, 15, '16_5', 20, 22, 25, 30, 33, 35, 40, 44, 45, 50, 55, 60, 65, 66, 70, 75, 80, 85, 90, 95, 100),
        'eval'      => array('style' => 'width:50px'),
      ),
      'eSM_fl_clear'   => array
      (
        'label'     => &$GLOBALS['TL_LANG']['tl_module']['editable_cols']['eSM_fl_clear'],
        'inputType' => 'checkbox',
      ),
    );
  }

  /**
   * Generate list of fields and add missing ones from DCA
   *
   * @param mixed          $varValue
   * @param \DataContainer $dc
   *
   * @return array
   */
  public function onLoadCoAddressFields($varValue, $dc)
  {
    \Controller::loadDataContainer('tl_member');
    $arrDCA      = &$GLOBALS['TL_DCA']['tl_member']['fields'];
    $arrFields   = array();
    $arrValues   = \StringUtil::deserialize($varValue);
    $arrMandatory    = $this->getMandatoryMemberFields();

    if (!\is_array($arrValues)) {
      $arrValues = array();
    }

    foreach ($arrValues as $arrField) {
      $strName = $arrField['name'];
      if ($strName == ''
        || !isset($arrDCA[$strName])
        || $arrDCA[$strName]['eval']['feEditable'] == ''
      ) {
        continue;
      }
      if (\in_array($strName, $arrMandatory, true))
      {
        $arrField['enabled'] = '1';
      }
      $arrFields[$arrField['name']] = $arrField;
    }

    foreach (array_diff_key($arrDCA, $arrFields) as $strName => $arrField) {
      if ($arrField['eval']['feEditable'] == ''
      ) {
        continue;
      }

      $arrFields[$strName] = array(
        'enabled' => \in_array($strName, $arrMandatory, true) ? '1' : '',
        'name'    => $strName,
      );
    }

    return array_values($arrFields);
  }

  /**
   * save_callback to sort attribute wizard fields by enabled and drag'n drop
   *
   * @param mixed  $varValue The widget value
   * @param object $dc       The DataContainer object
   *
   * @return string
   */
  public function onSaveCoAddressFields($varValue, $dc)
  {
    $arrLegends  = array();
    $arrFields   = \StringUtil::deserialize($varValue);
    if (empty($arrFields) || !\is_array($arrFields)) {
      return $varValue;
    }
    $arrMandatory = $this->getMandatoryMemberFields();

    foreach ($arrFields as $k => $arrField) {
      if (\in_array($arrField['name'], $arrMandatory, true)) {
        $arrFields[$k]['enabled'] = '1';
      }
    }
    uksort($arrFields, function ($a, $b) use ($arrFields) {
      if ($arrFields[$a]['enabled'] && !$arrFields[$b]['enabled']) {
        return -1;
      } elseif ($arrFields[$b]['enabled'] && !$arrFields[$a]['enabled']) {
        return 1;
      } else {
        return ($a > $b) ? +1 : -1;
      }
    });
    $arrValues = array();
    foreach (array_values($arrFields) as $pos => $arrConfig) {
      $arrConfig['position']         = $pos;
      $arrValues[$arrConfig['name']] = $arrConfig;
    }
    return serialize($arrValues);
  }
}