<?php

declare(strict_types=1);

/*
 * This file is part of formilicious bundle for Contao.
 *
 * (c) Benjamin Roth
 *
 * @license LGPL-3.0-or-later
 */

namespace vonRotenberg\FormiliciousBundle\EventListener\DataContainer;

use Contao\CoreBundle\ServiceAnnotation\Callback;

/**
 * @Callback(table="tl_form_field", target="list.sorting.child_record")
 */
class FormFieldChildRecordListener
{

    public function __invoke(array $arrRow): string
    {
        $dcaClass = new \tl_form_field();

        $buffer = $dcaClass->listFormFields($arrRow);

        if (!$arrRow['eSM_fl_width'] && !$arrRow['eSM_fl_clear'])
        {
            return $buffer;
        }

        $entry = new \DOMDocument();
        $entry->loadHTML($buffer);
        $finder = new \DomXPath($entry);

        $cteLabel = $finder->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' cte_type ')]");
        if ($cteLabel->length)
        {
            /** @var \DOMElement $item */
            foreach($cteLabel as $item)
            {
                if ($arrRow['eSM_fl_width'])
                {
                    $item->nodeValue.= ' ['.(isset($GLOBALS['TL_LANG']['tl_form_field']['ref_width'][$arrRow['eSM_fl_width']]) ? $GLOBALS['TL_LANG']['tl_form_field']['ref_width'][$arrRow['eSM_fl_width']] : 'w' . $arrRow['eSM_fl_width']).']';
                }
                if ($arrRow['eSM_fl_clear'])
                {
                    $item->nodeValue.= ' ↲';
                }
            }
        }

        return $entry->saveHTML();
    }
}
