<?php

declare(strict_types=1);

/*
 * This file is part of formilicious bundle for Contao.
 *
 * (c) Benjamin Roth
 *
 * @license LGPL-3.0-or-later
 */

namespace vonRotenberg\FormiliciousBundle\EventListener;

use Contao\CoreBundle\DependencyInjection\Attribute\AsHook;
use Contao\Form;
use Contao\Widget;
use Contao\FormSubmit;

#[AsHook('loadFormField')]
class LoadFormFieldListener
{
    public function __invoke(Widget $widget, string $formId, array $formData, Form $form): Widget
    {

        if ($widget->eSM_fl_width)
        {
            $widget->prefix.= ' w' . $widget->eSM_fl_width;
        }

        if ($widget->eSM_fl_class)
        {
            $widget->prefix.= ' ' . $widget->eSM_fl_class;
        }

        if ($widget->eSM_fl_clear)
        {
            $widget->prefix.= ' clr';
        }

        if ($widget instanceof FormSubmit)
        {
            if ($widget->eSM_fl_lblpadding)
            {
                $widget->prefix.= ' lblp';
            }

            if ($widget->eSM_fl_alignment)
            {
                $widget->prefix.= ' ' . $widget->eSM_fl_alignment.'-alignment';
            }
        }

        return $widget;
    }
}
