<?php

declare(strict_types=1);

/*
 * This file is part of formilicious bundle for Contao.
 *
 * (c) Benjamin Roth
 *
 * @license LGPL-3.0-or-later
 */

namespace vonRotenberg\FormiliciousBundle\ContaoManager;

use Contao\CoreBundle\ContaoCoreBundle;
use Contao\ManagerPlugin\Bundle\BundlePluginInterface;
use Contao\ManagerPlugin\Bundle\Config\BundleConfig;
use Contao\ManagerPlugin\Bundle\Parser\ParserInterface;
use vonRotenberg\FormiliciousBundle\VonrotenbergFormiliciousBundle;

class Plugin implements BundlePluginInterface
{
    public function getBundles(ParserInterface $parser): array
    {
        return [
            BundleConfig::create(VonrotenbergFormiliciousBundle::class)
                ->setLoadAfter([ContaoCoreBundle::class]),
        ];
    }
}
