<?php

/**
 * eSales Media Formilicious for Contao Open Source CMS
 *
 * Copyright (C) 2013-2014 eSalesMedia
 *
 * @package    eSM_formilicious
 * @link       http://www.esales-media.de
 * @license    http://www.gnu.org/licenses/lgpl-3.0.html LGPL
 *
 * @author     Benjamin Roth <benjamin@esales-media.de>
 */

namespace eSM_formilicious;

abstract class Widget extends \Contao\Widget
{

  /**
   * Extract the Widget attributes from a Data Container array
   *
   * @param array  $arrData  The field configuration array
   * @param string $strName  The field name in the form
   * @param mixed  $varValue The field value
   * @param string $strField The field name in the database
   * @param string $strTable The table name in the database
   * @param object $objDca   An optional DataContainer object
   *
   * @return array An attributes array that can be passed to a widget
   */
  public static function getAttributesFromDca($arrData, $strName, $varValue=null, $strField='', $strTable='', $objDca=null)
  {
    $arrAttributes = parent::getAttributesFromDca($arrData, $strName, $varValue, $strField, $strTable, $objDca);

    if (isset($arrData['eval']['eSM_fl_width']))
    {
      $arrAttributes['eSM_fl_width'] = $arrData['eval']['eSM_fl_width'];
    }

    if (isset($arrData['eval']['eSM_fl_clear']))
    {
      $arrAttributes['eSM_fl_clear'] = $arrData['eval']['eSM_fl_clear'];
    }

    if (isset($arrData['eval']['eSM_fl_class']))
    {
      $arrAttributes['eSM_fl_class'] = $arrData['eval']['eSM_fl_class'];
    }

    if (isset($arrData['eval']['eSM_fl_lblpadding']))
    {
      $arrAttributes['eSM_fl_lblpadding'] = $arrData['eval']['eSM_fl_lblpadding'];
    }

    if (isset($arrData['eval']['eSM_fl_alignment']))
    {
      $arrAttributes['eSM_fl_alignment'] = $arrData['eval']['eSM_fl_alignment'];
    }

    return $arrAttributes;
  }
}