<?php

/**
 * eSales Media Formilicious for Contao Open Source CMS
 *
 * Copyright (C) 2013-2014 eSalesMedia
 *
 * @package    eSM_formilicious
 * @link       http://www.esales-media.de
 * @license    http://www.gnu.org/licenses/lgpl-3.0.html LGPL
 *
 * @author     Benjamin Roth <benjamin@esales-media.de>
 */


/**
 * Run in a custom namespace, so the class can be replaced
 */
namespace eSM_formilicious;


/**
 * Class ModuleRegistration
 *
 * Front end module "registration".
 * @copyright  Leo Feyer 2005-2014
 * @author     Leo Feyer <https://contao.org>
 * @package    Core
 */
class ModuleRegistration extends \Contao\ModuleRegistration
{
  protected $originalDca;

  public function generate()
  {
    $return = parent::generate();
    $GLOBALS['TL_DCA']['tl_member'] = $this->originalDca;

    return $return;
  }


  /**
   * Generate the module
   */
  protected function compile()
  {
    /** @var \PageModel $objPage */
    global $objPage;

    $GLOBALS['TL_LANGUAGE'] = $objPage->language;

    \System::loadLanguageFile('tl_member');
    $this->loadDataContainer('tl_member');
    $this->originalDca = $GLOBALS['TL_DCA']['tl_member'];

    $arrEditable = [];
    foreach ($this->editable as $key=>$fielddata)
    {
      // Split formilicious editable data in single vars
      list($active, $field, $fieldMandatory, $fieldClass, $fieldWidth, $fieldClr, $position) = array_values($fielddata);

      if (!$active)
      {
        continue;
      }

      $GLOBALS['TL_DCA']['tl_member']['fields'][$field]['eval']['eSM_fl_class'] = $fieldClass;
      $GLOBALS['TL_DCA']['tl_member']['fields'][$field]['eval']['eSM_fl_width'] = $fieldWidth;
      $GLOBALS['TL_DCA']['tl_member']['fields'][$field]['eval']['eSM_fl_clear'] = $fieldClr;
      if ($fieldMandatory)
      {
        $GLOBALS['TL_DCA']['tl_member']['fields'][$field]['eval']['mandatory'] = $fieldMandatory == 'yes' ? true : false;
      }
      $arrEditable[$key] = $field;
    }
    $this->editable = $arrEditable;

    parent::compile();

  }
}
