<?php

declare(strict_types=1);

/*
 * This file is part of formilicious bundle for Contao.
 *
 * (c) Benjamin Roth
 *
 * @license LGPL-3.0-or-later
 */

namespace vonRotenberg\FormiliciousBundle\EventListener;

use Contao\CoreBundle\DataContainer\PaletteManipulator;
use Contao\CoreBundle\DependencyInjection\Attribute\AsHook;

#[AsHook('loadDataContainer')]
class LoadDataContainerListener
{
    /**
     * Array containing all fields which shouldn't use Formilicous extensions
     * @var array
     */
    protected $arrNoFl = array('__selector__','fieldsetStart','fieldsetStop','hidden','html','headline');

    public function __invoke(string $table): void
    {
        if ($table != 'tl_form_field')
        {
            return;
        }

        // Hook in the Formilicious fields
        if (is_array($GLOBALS['TL_DCA']['tl_form_field']['palettes']))
        {
            $palettes = array_diff(array_keys($GLOBALS['TL_DCA']['tl_form_field']['palettes']),$this->arrNoFl);

            $PaletteManipulator = PaletteManipulator::create()
                ->addLegend('formilicious_legend','expert_legend',PaletteManipulator::POSITION_BEFORE)
                ->addField('eSM_fl_width','formilicious_legend',PaletteManipulator::POSITION_APPEND)
                ->addField('eSM_fl_clear','formilicious_legend',PaletteManipulator::POSITION_APPEND)
                ->addField('eSM_fl_class','formilicious_legend',PaletteManipulator::POSITION_APPEND)
            ;

            foreach ($palettes as $palette)
            {
                $pm = clone $PaletteManipulator;
                if ($palette == 'submit')
                {
                    $pm
                        ->addField('eSM_fl_lblpadding','formilicious_legend',PaletteManipulator::POSITION_APPEND)
                        ->addField('eSM_fl_alignment','formilicious_legend',PaletteManipulator::POSITION_APPEND)
                    ;
                }
                $pm->applyToPalette($palette,'tl_form_field');
            }
        }
    }

}
