<?php

declare(strict_types=1);

/*
 * This file is part of formilicious bundle for Contao.
 *
 * (c) Benjamin Roth
 *
 * @license LGPL-3.0-or-later
 */

namespace vonRotenberg\FormiliciousBundle\EventListener;

use Contao\Controller;
use Contao\CoreBundle\DependencyInjection\Attribute\AsHook;
use Contao\DataContainer;

#[AsHook('getAttributesFromDca')]
class GetAttributesFromDca
{
    public function __invoke(array $arrAttributes, $context): array
    {
        if ($context instanceof DataContainer && $context->field)
        {
            Controller::loadDataContainer($context->table);
            $arrData = $GLOBALS['TL_DCA'][$context->table]['fields'][$context->field];

            if (isset($arrData['eval']['eSM_fl_width']))
            {
                $arrAttributes['eSM_fl_width'] = $arrData['eval']['eSM_fl_width'];
            }

            if (isset($arrData['eval']['eSM_fl_clear']))
            {
                $arrAttributes['eSM_fl_clear'] = $arrData['eval']['eSM_fl_clear'];
            }

            if (isset($arrData['eval']['eSM_fl_class']))
            {
                $arrAttributes['eSM_fl_class'] = $arrData['eval']['eSM_fl_class'];
            }

            if (isset($arrData['eval']['eSM_fl_lblpadding']))
            {
                $arrAttributes['eSM_fl_lblpadding'] = $arrData['eval']['eSM_fl_lblpadding'];
            }

            if (isset($arrData['eval']['eSM_fl_alignment']))
            {
                $arrAttributes['eSM_fl_alignment'] = $arrData['eval']['eSM_fl_alignment'];
            }
        }

        if (!isset($arrAttributes['class']))
        {
            $arrAttributes['class'] = '';
        }

        if (isset($arrAttributes['eSM_fl_width']) && is_numeric($arrAttributes['eSM_fl_width']))
        {
            $arrAttributes['class'].= ' w' . $arrAttributes['eSM_fl_width'];
        }

        if (isset($arrAttributes['eSM_fl_class']))
        {
            $arrAttributes['class'].= ' ' . $arrAttributes['eSM_fl_class'];
        }

        if (isset($arrAttributes['eSM_fl_clear']) && $arrAttributes['eSM_fl_clear'])
        {
            $arrAttributes['class'].= ' clr';
        }

        if (isset($arrAttributes['type']) && $arrAttributes['type'] === 'submit')
        {
            if (isset($arrAttributes['eSM_fl_lblpadding']))
            {
                $arrAttributes['class'].= ' lblp';
            }

            if (isset($arrAttributes['eSM_fl_alignment']))
            {
                $arrAttributes['class'].= ' ' . $arrAttributes['eSM_fl_alignment'].'_alignment';
            }
        }
        return $arrAttributes;
    }
}
