<?php

/**
 * eSales Media Formilicious for Contao Open Source CMS
 *
 * Copyright (C) 2013-2014 eSalesMedia
 *
 * @package    eSM_formilicious
 * @link       http://www.esales-media.de
 * @license    http://www.gnu.org/licenses/lgpl-3.0.html LGPL
 *
 * @author     Benjamin Roth <benjamin@esales-media.de>
 */

namespace eSM_formilicious;

class FormiliciousHooks extends \Controller
{

	/**
	 * Array containing all fields which shouldn't use Formilicous extensions
	 * @var array
	 */
	protected $arrNoFl = array('__selector__','fieldsetfsStart','fieldsetfsStop','hidden');

	/**
	 * Hook for adding Formilicious fields to the form editor
	 * @param $strName
	 */
	public function eSMLoadDataContainer($strName)
	{
		if ($strName != 'tl_form_field')
		{
			return;
		}

		// Hook in the Formilicious fields
		if (is_array($GLOBALS['TL_DCA']['tl_form_field']['palettes']))
		{
			foreach (array_keys($GLOBALS['TL_DCA']['tl_form_field']['palettes']) as $k)
			{
				if (!in_array($k,$this->arrNoFl))
				{
					$strFl = ';{formilicious_legend},eSM_fl_width,eSM_fl_clear,eSM_fl_class';
					if ($k == 'submit')
					{
						$strFl.= ',eSM_fl_lblpadding,eSM_fl_alignment';
					}
					$intPos = strpos($GLOBALS['TL_DCA']['tl_form_field']['palettes'][$k], ';{expert_legend');
					$intDupe = strpos($GLOBALS['TL_DCA']['tl_form_field']['palettes'][$k], ';{formilicious_legend');
					if ($intPos !== false && $intDupe === false)
					{
						$GLOBALS['TL_DCA']['tl_form_field']['palettes'][$k] =
							substr($GLOBALS['TL_DCA']['tl_form_field']['palettes'][$k], 0, $intPos) .
							$strFl .
							substr($GLOBALS['TL_DCA']['tl_form_field']['palettes'][$k], $intPos);
					}
					else if ($intDupe === false)
					{
						$GLOBALS['TL_DCA']['tl_form_field']['palettes'][$k] .= $strFl;
					}
				}
			}
		}
	}
}