import { LitElement, html, css } from 'lit';

export class WinzerMenuGroup extends LitElement {
    static properties = { items: { type: Array } };
    static styles = css`
        :host { display: block; margin-bottom: 20px; }
        .menu-group { background-color: var(--bg-card); border-radius: var(--radius-sm); overflow: hidden; box-shadow: var(--shadow-sm); }
        .menu-item { display: flex; align-items: center; padding: 16px 20px; cursor: pointer; background: var(--bg-white); border-bottom: 1px solid var(--border-color); font-size: 0.95rem; font-weight: 600; color: var(--text-dark); }
        .menu-item:last-child { border-bottom: none; }
        .menu-item:active { background-color: #f9f9f9; }
        .menu-icon { width: 24px; height: 24px; margin-right: 16px; color: var(--primary-color); display: flex; justify-content: center; align-items: center; }
        .menu-icon svg { width: 100%; height: 100%; display: block; }
        .chevron { margin-left: auto; color: var(--primary-color); width: 18px; height: 18px; }
    `;
    _handleItemClick(item) { this.dispatchEvent(new CustomEvent('item-click', { detail: { action: item.action, label: item.label }, bubbles: true, composed: true })); }
    render() {
        if (!this.items || this.items.length === 0) return html``;
        return html`<div class="menu-group">${this.items.map(item => html`<div class="menu-item" @click="${() => this._handleItemClick(item)}"><div class="menu-icon"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">${item.icon}</svg></div><span>${item.label}</span><svg class="chevron" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M9 18l6-6-6-6"/></svg></div>`)}</div>`;
    }
}
customElements.define('winzer-menu-group', WinzerMenuGroup);
