import { LitElement, html, css } from 'lit';

export class WinzerModal extends LitElement {
    static properties = { open: { type: Boolean }, title: { type: String } };
    static styles = css`
        :host { display: block; }
        .backdrop { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(var(--primary-rgb), 0.85); backdrop-filter: blur(4px); z-index: 1000; display: flex; justify-content: center; align-items: flex-start; padding-top: 120px; opacity: 0; pointer-events: none; transition: opacity 0.3s ease; }
        :host([open]) .backdrop { opacity: 1; pointer-events: all; }
        .modal-container { width: 90%; max-width: 400px; display: flex; flex-direction: column; gap: 16px; transform: translateY(20px); transition: transform 0.3s ease; }
        :host([open]) .modal-container { transform: translateY(0); }
        .modal-header { background-color: var(--primary-light); color: var(--primary-color); padding: 16px 20px; border-radius: var(--radius-sm); display: flex; justify-content: space-between; align-items: center; font-weight: 600; font-size: 0.95rem; text-transform: uppercase; box-shadow: var(--shadow-lg); }
        .close-btn { cursor: pointer; width: 24px; height: 24px; display: flex; align-items: center; justify-content: center; }
        .close-btn svg { width: 20px; height: 20px; stroke: var(--primary-color); stroke-width: 2; }
    `;
    _close() { this.dispatchEvent(new CustomEvent('close')); }
    render() {
        return html`<div class="backdrop" @click="${(e) => e.target.classList.contains('backdrop') && this._close()}"><div class="modal-container"><div class="modal-header"><span>${this.title}</span><div class="close-btn" @click="${this._close}"><svg viewBox="0 0 24 24"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg></div></div><slot></slot></div></div>`;
    }
}
customElements.define('winzer-modal', WinzerModal);
