<?php

declare(strict_types=1);

/*
 * This file is part of luumiCORE Core Bundle.
 *
 * (c) vonRotenberg
 *
 * @license proprietary
 */

namespace luumicore\CoreBundle\ContaoManager;

use Contao\CoreBundle\ContaoCoreBundle;
use Contao\ManagerPlugin\Bundle\BundlePluginInterface;
use Contao\ManagerPlugin\Bundle\Config\BundleConfig;
use Contao\ManagerPlugin\Bundle\Parser\ParserInterface;
use luumicore\CoreBundle\LuumicoreCoreBundle;

class Plugin implements BundlePluginInterface
{
    public function getBundles(ParserInterface $parser): array
    {
        return [
            BundleConfig::create(LuumicoreCoreBundle::class)
                ->setLoadAfter([ContaoCoreBundle::class]),
        ];
    }
}
