import { LitElement, html, css } from 'lit';

export class LuumicoreListItem extends LitElement {
  static styles = css`
    :host {
      display: block;
      border-bottom: 1px solid var(--luumicore-border-color, #ddd);
      background-color: var(--luumicore-list-bg, #fff);
    }

    :host(:last-child) {
      border-bottom: none;
    }

    .item-container {
      display: flex;
      align-items: center;
      padding: var(--luumicore-spacing, 12px) var(--luumicore-spacing, 16px);
      gap: var(--luumicore-spacing, 16px);
    }

    .content {
      flex: 1;
      min-width: 0; /* Allow text truncation */
    }

    .actions {
      display: flex;
      align-items: center;
      gap: 8px;
    }

    .main-action {
      margin-left: auto;
    }
  `;

  render() {
    return html`
      <div class="item-container">
        <div class="content">
          <slot></slot>
        </div>

        <div class="actions">
          <slot name="actions"></slot>
        </div>

        <div class="main-action">
          <slot name="main-action"></slot>
        </div>
      </div>
    `;
  }
}

customElements.define('luumicore-list-item', LuumicoreListItem);
