import { LitElement, html, css } from 'lit';

export class LuumicoreCard extends LitElement {
  static styles = css`
    :host {
      display: block;
      border: 1px solid var(--luumicore-border-color, #ddd);
      border-radius: var(--luumicore-border-radius, 8px);
      overflow: hidden;
      background-color: var(--luumicore-card-bg, #fff);
      box-shadow: var(--luumicore-shadow, 0 2px 4px rgba(0,0,0,0.1));
    }

    .card-image {
      width: 100%;
      height: auto;
      display: block;
    }

    .card-header {
      padding: var(--luumicore-spacing, 16px);
      border-bottom: 1px solid var(--luumicore-border-color, #ddd);
      font-weight: bold;
      background-color: var(--luumicore-header-bg, #f8f9fa);
    }

    .card-body {
      padding: var(--luumicore-spacing, 16px);
    }

    .card-footer {
      padding: var(--luumicore-spacing, 16px);
      border-top: 1px solid var(--luumicore-border-color, #ddd);
      background-color: var(--luumicore-footer-bg, #f8f9fa);
    }
  `;

  static properties = {
    imageUrl: { type: String, attribute: 'image-url' },
    imageAlt: { type: String, attribute: 'image-alt' },
  };

  render() {
    return html`
      ${this.imageUrl
        ? html`<img class="card-image" src="${this.imageUrl}" alt="${this.imageAlt || ''}" />`
        : ''}

      <slot name="header" class="card-header-slot"></slot>

      <div class="card-body">
        <slot></slot>
      </div>

      <slot name="footer" class="card-footer-slot"></slot>
    `;
  }
}

customElements.define('luumicore-card', LuumicoreCard);
