import { LitElement, html, css } from 'lit';

export class WinzerHeader extends LitElement {
    static properties = { mainTitle: { type: String, attribute: 'main-title' }, subTitle: { type: String, attribute: 'sub-title' } };
    static styles = css`
        :host { display: block; background: var(--bg-white); padding: 10px 20px; border-bottom: 1px solid var(--border-color); }
        .top-bar { display: flex; align-items: center; justify-content: space-between; height: 60px; }
        .logo-placeholder { border: 1px solid var(--primary-color); width: 40px; height: 40px; display: flex; flex-direction: column; align-items: center; justify-content: center; font-size: 8px; color: var(--primary-color); font-weight: bold; line-height: 1; }
        .title-group { text-align: center; }
        .main-title { color: var(--primary-color); font-weight: bold; font-size: 1rem; text-transform: uppercase; }
        .sub-title { font-size: 0.9rem; color: var(--primary-color); }
        .user-icon { width: 32px; height: 32px; color: var(--text-main); cursor: pointer; }
    `;
    _handleUserClick() { this.dispatchEvent(new CustomEvent('user-click', { bubbles: true, composed: true })); }
    render() {
        return html`<div class="top-bar"><div class="logo-placeholder"><span>luumi</span><span>CORE</span></div><div class="title-group"><div class="main-title">${this.mainTitle || ''}</div><div class="sub-title">${this.subTitle || ''}</div></div><svg class="user-icon" @click="${this._handleUserClick}" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-width="2" d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/><circle cx="12" cy="7" r="4" fill="none" stroke="currentColor" stroke-width="2"/></svg></div>`;
    }
}
customElements.define('winzer-header', WinzerHeader);
