import { LitElement, html, css } from 'lit';

export class ToggleSwitch extends LitElement {
    static properties = { checked: { type: Boolean } };
    static styles = css`
        .switch { position: relative; display: inline-block; width: 44px; height: 24px; }
        .switch input { opacity: 0; width: 0; height: 0; }
        .slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #ddd; transition: .4s; border-radius: 24px; }
        .slider:before { position: absolute; content: ""; height: 18px; width: 18px; left: 3px; bottom: 3px; background-color: var(--bg-white); transition: .4s; border-radius: 50%; }
        input:checked + .slider { background-color: var(--primary-color); }
        input:checked + .slider:before { transform: translateX(20px); }
    `;
    render() { return html`<label class="switch"><input type="checkbox" ?checked="${this.checked}" @change="${e => this.checked = e.target.checked}"><span class="slider"></span></label>`; }
}
customElements.define('toggle-switch', ToggleSwitch);
